#!/bin/ksh
# dd if=/dev/zero of=/dev/rloglv bs=4096k count=21
#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################
db2set DB2_APM_PERFORMANCE=ON
db2set DB2_KEEPTABLELOCK=CONNECTION
db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2_MINIMIZE_LISTPREFETCH=YES
#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################
db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT on DFT_MON_TIMESTAMP off DFT_MON_UOW off  DFT_MON_TABLE off
db2 -v update dbm cfg using MAX_COORDAGENTS 2770 automatic
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using SVCENAME 60004
db2 -v connect to specdb
############################################
# DATABASE CONFIGURATION TUNING            #
############################################
db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using LOGPRIMARY 150
db2 -v update db cfg for specdb using SOFTMAX 3000
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99
db2 -v update db cfg for specdb using LOGFILSIZ 65535
db2 -v update db cfg for specdb using LOGSECOND 0
db2 -v update db cfg for specdb using NEWLOGPATH /dev/speclogs/speclogLV
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using LOCKLIST 100000 MAXLOCKS 100
db2 -v update db cfg for specdb using MINCOMMIT 1
db2 -v update db cfg for specdb using MON_REQ_METRICS none
db2 -v update db cfg for specdb using MON_ACT_METRICS none
db2 -v update db cfg for specdb using MON_OBJ_METRICS none
db2 -v update db cfg for specdb using AUTO_STMT_STATS off
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
############################################
# BUFFER POOL TUNING                       #
############################################
db2 -v alter bufferpool IBMDEFAULTBP immediate size 3000000 automatic 
db2 -v alter bufferpool JMS_BP immediate size 192213 automatic 
db2 -v alter bufferpool JMS_IDX_BP immediate size 2500 
db2 -v alter bufferpool M_INV_BP immediate size 102694 automatic
db2 -v alter bufferpool M_PARTS_BP immediate size 50352 automatic
db2 -v alter bufferpool M_BOM_BP immediate size 18791 automatic
db2 -v alter bufferpool M_WO_BP immediate size 15000 automatic
db2 -v alter bufferpool O_ORDERS_BP immediate size 141587 automatic 
db2 -v alter bufferpool O_ORDERS2_BP immediate size 161058 automatic 
db2 -v alter bufferpool O_OL_BP immediate size 241587 automatic 
db2 -v alter bufferpool O_CI_BP immediate size 1784559 automatic 
db2 -v alter bufferpool O_CUSTOMER_BP immediate size 791785 automatic
db2 -v alter bufferpool O_ITEM_BP immediate size 1550 automatic 
db2 -v alter bufferpool O_ITEM2_BP immediate size 500 automatic
db2 -v alter bufferpool S_COMPONENT_BP immediate size 241586 automatic
db2 -v alter bufferpool S_S_C_BP immediate size 161058 automatic
db2 -v alter bufferpool S_P_O_BP immediate size 362380 automatic 
db2 -v alter bufferpool S_P_OL_BP immediate size 72693 automatic 
db2 -v alter bufferpool DATA_BP immediate size 7000000 automatic 
############################################
# TABLE TUNING                             #
############################################
db2 -v alter table O_ITEM  volatile
db2 -v alter table S_SUPPLIER volatile
db2 -v alter table M_WORKORDER volatile
db2 -v alter table O_ORDERLINE append on
db2 -v alter table O_CUSTINVENTORY append on
db2 -v alter table O_ORDERS append on
db2 -v alter table S_PURCH_ORDER append on
db2 -v alter table S_PURCH_ORDERLINE append on
db2 -v alter table M_INVENTORY volatile
db2 -v terminate
db2set DB2COMM=TCPIP
db2stop force
db2start
