#!/bin/ksh
#RAWLOG=/dev/sdb
#test ! -b ${RAWLOG}1 \
#	&& test -b $RAWLOG \
#	&& dd if=/dev/zero of=$RAWLOG bs=4096k count=21
#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################
db2set DB2_COLLECT_TS_REC_INFO=FALSE
db2set DB2_APM_PERFORMANCE=ON
db2set DB2_KEEPTABLELOCK=CONNECTION
db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2_MINIMIZE_LISTPREFETCH=YES

#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################
db2 -v update dbm cfg using DIAGLEVEL 3 
db2 -v update dbm cfg using DFT_MON_BUFPOOL off DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT off DFT_MON_TIMESTAMP off DFT_MON_UOW off  DFT_MON_TABLE off
db2 -v update dbm cfg using MAX_COORDAGENTS 350 automatic
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using HEALTH_MON off
db2 -v update dbm cfg using SVCENAME 60004
db2 -v connect to specdb
############################################
# DATABASE CONFIGURATION TUNING            #
############################################
db2 -v update db cfg for specdb using SELF_TUNING_MEM OFF
db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using LOGSECOND 0
db2 -v update db cfg for specdb using LOGPRIMARY 256 
db2 -v update db cfg for specdb using SOFTMAX 8080
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99
db2 -v update db cfg for specdb using LOGFILSIZ 65535 
db2 -v update db cfg for specdb using NUM_IOCLEANERS 16
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using LOCKLIST 100000 MAXLOCKS 100
db2 -v update db cfg for specdb using MINCOMMIT 1
db2 -v update db cfg for specdb using MON_REQ_METRICS none
db2 -v update db cfg for specdb using MON_ACT_METRICS none
db2 -v update db cfg for specdb using MON_OBJ_METRICS none
db2 -v update db cfg for specdb using AUTO_STMT_STATS off
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
############################################
# BUFFER POOL TUNING                       #
############################################
./bptune.sh
db2 connect to specdb
############################################
# TABLE TUNING                             #
############################################
db2 -v alter table O_ITEM  volatile
db2 -v alter table S_SUPPLIER volatile
db2 -v alter table M_WORKORDER volatile
db2 -v alter table O_ORDERLINE append on
db2 -v alter table O_CUSTINVENTORY append on
db2 -v alter table O_ORDERS append on
db2 -v alter table S_PURCH_ORDER append on
db2 -v alter table S_PURCH_ORDERLINE append on
db2 -v alter table M_INVENTORY volatile
db2 -v terminate
db2set DB2COMM=TCPIP
