#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####

CUST=${DB_DIR}/C_cust
SUPP=${DB_DIR}/C_supp
SITE=${DB_DIR}/C_site
PARTS=${DB_DIR}/C_parts


#sqlplus '/ as sysdba'  <<EOT  
#shutdown
#startup
#EOT

sqlplus '/ as sysdba'  <<EOT 
DROP TABLESPACE C_cust_space INCLUDING CONTENTS;
DROP TABLESPACE C_supp_space INCLUDING CONTENTS;
DROP TABLESPACE C_site_space INCLUDING CONTENTS;
DROP TABLESPACE C_parts_space INCLUDING CONTENTS;

CREATE TABLESPACE C_cust_space
	DATAFILE '${CUST}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE C_supp_space
	DATAFILE '${SUPP}' SIZE 990M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE C_site_space
	DATAFILE '${SITE}' SIZE 990M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE C_parts_space
	DATAFILE '${PARTS}' SIZE 990M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
EXIT
EOT

wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_C
EOT
