#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####
PART=${DB_DIR}/M_parts
BOM=${DB_DIR}/M_bom
WO=${DB_DIR}/M_wrkorder
LO=${DB_DIR}/M_lrgorder
INV=${DB_DIR}/M_inv

#sqlplus <<EOT  
#CONNECT / as sysdba
#shutdown
#startup 
#EOT

sqlplus <<EOT 
CONNECT / as sysdba
DROP TABLESPACE M_parts_space INCLUDING CONTENTS;
DROP TABLESPACE M_bom_space INCLUDING CONTENTS;
DROP TABLESPACE M_wo_space INCLUDING CONTENTS;
DROP TABLESPACE M_lo_space INCLUDING CONTENTS;
DROP TABLESPACE M_inv_space INCLUDING CONTENTS;

CREATE TABLESPACE M_parts_space
	DATAFILE '${PART}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE M_bom_space
	DATAFILE '${BOM}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE M_wo_space
	DATAFILE '${WO}' SIZE 5990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE M_lo_space
	DATAFILE '${LO}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE M_inv_space
	DATAFILE '${INV}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
EXIT
EOT

wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_M
EOT
