#!/bin/sh
#
# Copyright (c) 1998 by Sun Microsystems, Inc.
#
# $Id: createdb.sh 
#
# Script to create oracle database
#####################################################

##################
# check Parameters
##################
if [ $# -ne 2 ]
then
	echo "Usage: createdb.sh <database_name> <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi


####################
# Set the database and database directory vars
#####################
DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID

###################################################
# If the database already exists warn that we will 
# destroy it.
####################################################
if [ -f "$ORACLE_HOME"/dbs/init${DB}.ora  ]
then
	echo  "$ORACLE_HOME"/dbs/init${DB}.ora
	/usr/bin/echo "Database already exists. Ok to destroy y/n ? \c"
	read junk
	if [ "$junk" != 'y' -a "$junk" != 'Y' ]
	then
		echo  "database create cancelled"
		exit 1
	fi
fi
####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
if [ ! -d "$DB_DIR" ] 
then
	echo "$DB_DIR does not exist. Please create it first."
	exit 1
fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
echo "Creating the \$ORACLE_HOME/dbs .ora files ..."
create_init.sh $DB $DB_DIR

####################################
# Environment vars an params look ok
# so go build the database
####################################

SYS=${DB_DIR}/sys/sys_${DB}
SYS_AUX=${DB_DIR}/sys/sysaux_${DB}
LOG1=${DB_DIR}/logs1
LOG2=${DB_DIR}/logs2
ROLL=${DB_DIR}/roll/roll_${DB}
TEMP=${DB_DIR}/tmp/temp_${DB}

rm -f $SYS $TEMP $SYS_AUX

# Create database
sqlplus /nolog <<EOT
CONNECT / as sysdba
shutdown abort
startup nomount

create database $DB
controlfile reuse
logfile GROUP 1 '${LOG1}' size 198000M reuse,
	GROUP 2 '${LOG2}' size 208000M reuse
maxdatafiles 256
datafile '${SYS}' size 1200M reuse
sysaux datafile '${SYS_AUX}' size 1200M reuse
default TEMPORARY TABLESPACE temp_space
	TEMPFILE '${TEMP}' size 800M reuse
undo tablespace roll_space datafile '${ROLL}' size 9000M reuse
	blocksize 8k;
exit
EOT

################
# BEGIN COMMON
################

echo "Copying ./initspecdb.ora to startup the database"
cp initspecdb.ora ${ORACLE_HOME}/dbs/

echo "Running catalog scripts ..."
sqlplus /nolog<<EOT >/dev/null 2>&1
CONNECT / as sysdba
@?/rdbms/admin/catalog.sql;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT


sqlplus /nolog<<EOT
connect / as sysdba
CREATE USER spec IDENTIFIED BY spec;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;
EXIT
EOT


sqlplus /nolog<<EOT
CONNECT / as sysdba
ALTER USER spec
	TEMPORARY TABLESPACE temp_space;
EXIT
EOT

########################
# END OF DATABASE BUILD
########################
