#!/bin/ksh

##################
# check Parameters
##################
if [ $# -ne 1 ]
then
        echo "Usage: tbllock.sh [enable | disable]"
        exit 1
fi

ORACLE_SID=specdb
ORACLE_HOME=/export/databases/oracle10g

PATH=/export/databases/oracle10g/bin:${PATH}
export PATH ORACLE_SID ORACLE_HOME

sqlplus spec04/spec04 <<EOF

alter table C_CUSTOMERINVENTORY $1 table lock;
alter table C_CUSTOMER $1 table lock;
alter table C_SUPPLIER $1 table lock;
alter table C_SITE $1 table lock;
alter table C_PARTS $1 table lock;

alter table M_PARTS $1 table lock;
alter table M_BOM $1 table lock;
alter table M_WORKORDER $1 table lock;
alter table M_LARGEORDER $1 table lock;
alter table M_INVENTORY $1 table lock;

alter table O_ORDERS $1 table lock;
alter table O_ORDERLINE $1 table lock;
alter table O_ITEM $1 table lock;

alter table S_COMPONENT $1 table lock;
alter table S_SUPP_COMPONENT $1 table lock;
alter table S_SUPPLIER $1 table lock;
alter table S_SITE $1 table lock;
alter table S_PURCHASE_ORDER $1 table lock;
alter table S_PURCHASE_ORDERLINE $1 table lock;

alter table U_SEQUENCES $1 table lock;

exit;
EOF

