CREATE TABLE M_PARTS (
		P_ID CHAR(20) NOT NULL,
		P_NAME CHAR(10),
		P_DESC VARCHAR(100),
		P_REV CHAR(6),
		P_PLANNER INTEGER,
		P_TYPE INTEGER,
		P_IND INTEGER,
		P_LOMARK INTEGER,
		P_HIMARK INTEGER
	)
;

CREATE TABLE M_WORKORDER (
		WO_NUMBER INTEGER NOT NULL,
		WO_O_ID INTEGER,
		WO_OL_ID INTEGER,
		WO_STATUS INTEGER,
		WO_ORIG_QTY INTEGER,
		WO_COMP_QTY INTEGER,
		WO_DUE_DATE DATE,
		WO_START_DATE TIMESTAMP,
		WO_ASSEMBLY_ID CHAR(20)
	)
;

CREATE TABLE M_LARGEORDER (
		LO_ID INTEGER NOT NULL,
		LO_O_ID INTEGER,
		LO_OL_ID INTEGER,
		LO_ASSEMBLY_ID CHAR(20),
		LO_QTY SMALLINT,
		LO_DUE_DATE DATE,
		LO_CATEGORY INTEGER
	)
;

CREATE TABLE M_INVENTORY (
		IN_P_ID CHAR(20) NOT NULL,
		IN_QTY INTEGER,
		IN_LOCATION CHAR(20),
		IN_ACC_CODE INTEGER,
		IN_ACT_DATE DATE,
		IN_ORDERED INTEGER
	)
;

CREATE TABLE M_BOM (
		B_COMP_ID CHAR(20) NOT NULL,
		B_ASSEMBLY_ID CHAR(20) NOT NULL,
		B_LINE_NO INTEGER NOT NULL,
		B_QTY INTEGER,
		B_OPS INTEGER,
		B_ENG_CHANGE CHAR(10),
		B_OPS_DESC VARCHAR(100)
	)
;

ALTER TABLE M_PARTS ADD CONSTRAINT PK_PARTENT PRIMARY KEY (P_ID)
;

ALTER TABLE M_WORKORDER ADD CONSTRAINT PK_WORKORDERENT PRIMARY KEY (WO_NUMBER)
;

ALTER TABLE M_LARGEORDER ADD CONSTRAINT PK_LARGEORDERENT PRIMARY KEY (LO_ID)
;

ALTER TABLE M_INVENTORY ADD CONSTRAINT PK_INVENTORYENT PRIMARY KEY (IN_P_ID)
;

ALTER TABLE M_BOM ADD CONSTRAINT C3225281 PRIMARY KEY (B_COMP_ID, B_ASSEMBLY_ID, B_LINE_NO)
;

