#!/bin/bash
# Dileep Kumar
# This will dump out ur db to file for faster restore
# Saves time

db2 activate db specdb
db2 deactivate db specdb
db2set DB2_APM_PERFORMANCE=
db2stop force
db2start


echo `pwd`
CUR_DIR=`pwd`
echo "exporting database archive to ${CUR_DIR}/archive/archive_${1}..."
if [ -e ${CUR_DIR}/archive/archive_$1 ]
then
  echo "removing existing database archive"
  rm -Rf ${CUR_DIR}/archive/archive_$1
fi
mkdir -p ${CUR_DIR}/archive/archive_$1
echo "made dir ${CUR_DIR}/archive/archive_$1....."

echo "...starting exporting database archive"
db2 backup database specdb user db2inst1 using password to ${CUR_DIR}/archive/archive_$1
echo "...done exporting database archive"

db2set DB2_APM_PERFORMANCE=ON
db2 deactivate db specdb
db2 activate db specdb
db2stop force
db2start
