#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_S.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2


######  datafiles #####
COMP=${DB_DIR}/S_comp
SC=${DB_DIR}/S_suppcomp
SITE=${DB_DIR}/S_site
SUPP=${DB_DIR}/S_supp
PO=${DB_DIR}/S_po


##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE S_comp_space
db2 -v DROP TABLESPACE S_sc_space
db2 -v DROP TABLESPACE S_po_space
db2 -v DROP TABLESPACE S_site_space
db2 -v DROP TABLESPACE S_supp_space

# echo "Removing Datafiles"
rm -f $COMP > /dev/null 2>&1
rm -f $SC > /dev/null 2>&1
rm -f $SITE > /dev/null 2>&1
rm -f $SUPP > /dev/null 2>&1
rm -f $PO > /dev/null 2>&1
rm -f $BIDS > /dev/null 2>&1

##############################################
# Create the required tablespaces
##############################################
echo "Creating S table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v "CREATE TABLESPACE S_comp_space \
        managed by system using \
        ('$COMP') \
        extentsize 320K prefetchsize 320k \
        no file system caching"

db2 -v "CREATE TABLESPACE S_sc_space \
        managed by system using \
        ('$SC') \
        extentsize 320K prefetchsize 320k \
        no file system caching"

db2 -v "CREATE TABLESPACE S_po_space \
        managed by system using \
        ('$PO') \
        extentsize 320K prefetchsize 320k \
        no file system caching"

db2 -v "CREATE TABLESPACE S_site_space \
        managed by system using \
        ('$SITE') \
        extentsize 320K prefetchsize 320k \
        no file system caching"

db2 -v "CREATE TABLESPACE S_supp_space \
        managed by system using \
        ('$SUPP') \
        extentsize 320K prefetchsize 320k \
        no file system caching"

db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf /SPECjAppServer2004/schema/db2/sql/schema_S.sql
db2 -v connect reset

