set serveroutput on;
create or replace procedure analyse_objs
AS
  type indarr is table of varchar2(100) index by  binary_integer;
  type tabarr is table of varchar2(100) index by  binary_integer;
  table_names tabarr;
  index_names indarr;
  i number;
  exec_str  varchar2(100);
begin
  dbms_output.enable(100000);
  select table_name bulk collect into table_names from user_tables;
  for i in table_names.FIRST..table_names.LAST loop
        DBMS_STATS.GATHER_TABLE_STATS('spec04', table_names(i));
        dbms_output.put_line('Analyzed table ' || table_names(i));
  end loop;
  select index_name bulk collect into index_names from user_indexes;
  for i in index_names.FIRST..index_names.LAST loop
        dbms_stats.gather_index_stats('spec04', index_names(i));
        dbms_output.put_line('Analyzed index ' || index_names(i));
  end loop;
end;
/
show errors;
exit;
