#!/bin/sh
#
# Copyright (c) 2004 Standard Performance Evaluation Corporation (SPEC)
#                                All rights reserved.
#
# $Id: schema_O.sh,v 1.3 2004/04/21 13:51:22 skounev Exp $
#
# script to create the orders tables
# 
# Tom Daly Jan 2000 
#     modify script to build corp specific 
#     tables and tablespaces against an existing database
#     This is to allow all of spec to run on one database
#     which will allow for easier testng and installation.
#     schema_O.sh now takes database name and database directory 
#     parameters.
#     Note: The database must now exist prior to running this script
#     use the createdb.sh script to create it.
#                     
# April 2003 Balu Sthanikam: Updated for SJAS2004 and other changes.

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ $# -ne 2 ]
then
	echo "Usage: schema_O.sh <database_name> <database dir>"
	exit 1
fi

DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID


######  datafiles #####
ORDS=${DB_DIR}/O_ords

ITEM=${DB_DIR}/O_item

ORDL=${DB_DIR}/O_ordl

sqlplus <<EOT  
CONNECT / as sysdba
shutdown
startup 
EOT

##############################################
#  clean up datafiles from  earlier attempts
##############################################
echo "Cleaning up old tables spaces"
sqlplus <<EOT 
CONNECT / as sysdba
DROP TABLESPACE O_ords_space INCLUDING CONTENTS;
DROP TABLESPACE O_ordl_space INCLUDING CONTENTS;
DROP TABLESPACE O_item_space INCLUDING CONTENTS;
EOT

#rm -f ${ORDS} ${ITEM} ${ORDL} 

##############################################
# Create the required tablespaces
##############################################
# already up
#sqlplus <<EOT  
#CONNECT / as sysdba
#startup pfile=${ORACLE_HOME}/dbs/p_build_${DB}.ora
#EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE TABLESPACE O_ords_space
	DATAFILE '${ORDS}' SIZE 6000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE TABLESPACE O_ordl_space
	DATAFILE '${ORDL}' SIZE 6000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE O_item_space
	DATAFILE '${ITEM}' SIZE 6000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT


wait


##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_O
EOT
