#!/bin/sh

###############################
# Script to create DB2 database
###############################

##################
# check Parameters
##################

if [ $# -ne 3 ]
then
   echo "Usage: createdb.sh <database_name> <database dir> <database dir>"
   exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=$1
DB_DIR1=$2
DB_DIR2=$3


####################################
# Environment vars an params look ok
# so go build the database
####################################

SYS=${DB_DIR}/sys_${DB}
LOG1=${DB_DIR}/log1_${DB}
LOG2=${DB_DIR}/log2_${DB}
ROLL=${DB_DIR}/roll_${DB}
TEMP=${DB_DIR}/temp_${DB}

#echo Deleting existing $SYS...
rm -f $SYS > /dev/null 2>&1
#echo Deleting existing $LOG1...
rm -f $LOG1 > /dev/null 2>&1
#echo Deleting existing $LOG2...
rm -f $LOG2 > /dev/null 2>&1
#echo Deleting existing $ROLL...
rm -f $ROLL > /dev/null 2>&1
#echo Deleting existing $TEMP...
rm -f $TEMP > /dev/null 2>&1


################
# Create database
################
# Automatic Storage is implicit in DB2 9

db2 -v drop database ${DB}
db2 -v "create database ${DB} on ${DB_DIR1}, ${DB_DIR2} \
       USING CODESET ISO8859-1 TERRITORY US\
       TEMPORARY TABLESPACE \
       managed by automatic storage \
       extentsize 12 prefetchsize 24 \
       no file system caching"



#############################
# Create the ROLL space
#############################
# Using SMS for now (until more precise numbers are known)

db2 -v connect to ${DB}
db2 -v "CREATE TABLESPACE roll_space \
       managed by automatic storage \
       initialsize 1216M \
       extentsize 1024K prefetchsize 100K"
db2 -v connect reset

##################################
# New bufferpools
##################################

db2 -v connect to ${DB}
db2 -v "create bufferpool C_site_bp pagesize 4K"
db2 -v "create bufferpool C_site_idx_bp pagesize 4K"
db2 -v "create bufferpool C_supp_bp pagesize 4K"
db2 -v "create bufferpool C_supp_idx_bp pagesize 4K"
db2 -v "create bufferpool C_cust_bp pagesize 4K"
db2 -v "create bufferpool C_c_idx_bp pagesize 4K"
db2 -v "create bufferpool C_parts_bp pagesize 4K"
db2 -v "create bufferpool C_p_idx_bp pagesize 4K"
db2 -v "create bufferpool C_ci_bp pagesize 4K"
db2 -v "create bufferpool C_ci_idx_bp pagesize 4K"
db2 -v "create bufferpool O_cust_bp pagesize 4K"
db2 -v "create bufferpool O_ords_bp pagesize 4K"
db2 -v "create bufferpool O_ords_idx_bp pagesize 4K"
db2 -v "create bufferpool O_ordl_bp pagesize 4K"
db2 -v "create bufferpool O_ordl_idx_bp pagesize 4K"
db2 -v "create bufferpool O_item_bp pagesize 4K"
db2 -v "create bufferpool O_item_idx_bp pagesize 4K"
db2 -v "create bufferpool M_parts_bp pagesize 4K"
db2 -v "create bufferpool M_parts_idx_bp pagesize 4K"
db2 -v "create bufferpool M_bom_bp pagesize 4K"
db2 -v "create bufferpool M_bom_idx_bp pagesize 4K"
db2 -v "create bufferpool M_wo_bp pagesize 4K"
db2 -v "create bufferpool M_wo_idx_bp pagesize 4K"
db2 -v "create bufferpool M_lo_bp pagesize 4K"
db2 -v "create bufferpool M_lo_idx_bp pagesize 4K"
db2 -v "create bufferpool M_inv_bp pagesize 4K"
db2 -v "create bufferpool M_inv_idx_bp pagesize 4K"
db2 -v "create bufferpool S_comp_bp pagesize 4K"
db2 -v "create bufferpool S_comp_idx_bp pagesize 4K"
db2 -v "create bufferpool S_sc_bp pagesize 4K"
db2 -v "create bufferpool S_sc_idx_bp pagesize 4K"
db2 -v "create bufferpool S_po_bp pagesize 4K"
db2 -v "create bufferpool S_po_idx_bp pagesize 4K"
db2 -v "create bufferpool S_pol_bp pagesize 4K"
db2 -v "create bufferpool S_pol_idx_bp pagesize 4K"
db2 -v "create bufferpool S_site_bp pagesize 4K"
db2 -v "create bufferpool S_site_idx_bp pagesize 4K"
db2 -v "create bufferpool S_supp_bp pagesize 4K"
db2 -v "create bufferpool S_supp_idx_bp pagesize 4K"
db2 -v "create bufferpool U_bp pagesize 4K"
db2 -v "create bufferpool U_idx_bp pagesize 4K"
db2 -v connect reset

########################
# END OF DATABASE BUILD
########################

