#!/bin/ksh

dd if=/dev/zero of=/dev/rloglv bs=4096k count=21

db2set DB2_LARGE_PAGE_MEM=DB
db2set DB2_APM_PERFORMANCE=1,2,3,4,5,6,7,9 #on
db2set DB2_EVALUNCOMMITTED=on
db2set DB2_SKIPDELETED=on
db2set DB2_SKIPINSERTED=on
db2set DB2_KEEPTABLELOCK=ON
db2set DB2COMM=tcpip

# Database Manager Configuration Tunings
db2 -v update dbm cfg using diaglevel 1
db2 -v update dbm cfg using notifylevel 1
db2 -v update dbm cfg using aslheapsz 2000
db2 -v update dbm cfg using rqrioblk 65535
db2 -v update dbm cfg using DFT_MON_BUFPOOL off DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT off DFT_MON_TIMESTAMP on DFT_MON_UOW on
db2 -v update dbm cfg using HEALTH_MON off NUM_INITAGENTS 3900 NUM_POOLAGENTS 3900 MAX_COORDAGENTS 4000 MAX_CONNECTIONS 4000
db2 -v update dbm cfg using cpuspeed -1

db2 -v connect to specdb

# Database Configuration Tunings
db2 -v update db cfg for specdb using dft_queryopt 1
db2 -v update db cfg for specdb using dft_degree 1
db2 -v update db cfg using catalogcache_sz 260
db2 -v update db cfg using logbufsz 4096
#db2 -v update db cfg using util_heap_sz 524288
db2 -v update db cfg for specdb using num_iocleaners 40
db2 -v update db cfg for specdb using num_ioservers 6 
db2 -v update db cfg for specdb using logfilsiz 524286
db2 -v update db cfg for specdb using logsecond 0
db2 -v update db cfg for specdb using logprimary 256
db2 -v update db cfg for specdb using newlogpath /dev/rloglv
db2 -v update db cfg for specdb using softmax 532
db2 -v update db cfg for specdb using chngpgs_thresh 60
db2 -v update db cfg for specdb using auto_maint off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using maxlocks 100 locklist 18000
db2 -v update db cfg for specdb using maxappls 3950 avg_appls 3900
db2 -v update db cfg for specdb using dbheap 128000
db2 -v update db cfg for specdb using database_memory 46633600
db2 -v update db cfg for specdb using self_tuning_mem off
db2 -v update db cfg for specdb using pckcachesz 51200
db2 -v update db cfg for specdb using sheapthres_shr 192843
db2 -v update db cfg for specdb using sortheap 46000

# Bufferpool 
bptune.sh

db2 -v terminate

db2stop
dd if=/dev/zero of=/dev/rloglv bs=4096k count=21
db2start
