#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_M.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2

##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE M_parts_space
db2 -v DROP TABLESPACE M_bom_space
db2 -v DROP TABLESPACE M_wo_space
db2 -v DROP TABLESPACE M_lo_space
db2 -v DROP TABLESPACE M_inv_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating M table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v "CREATE TABLESPACE M_parts_space \
        managed by automatic storage \
	initialsize 16096M bufferpool M_parts_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE M_parts_idx_space \
	managed by automatic storage \
	initialsize 5850M bufferpool M_parts_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE M_bom_space \
        managed by automatic storage \
        initialsize 1512M bufferpool M_bom_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE M_bom_idx_space \
	managed by automatic storage \
	initialsize 936M bufferpool M_bom_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE M_wo_space \
        managed by automatic storage \
        initialsize 2G bufferpool M_wo_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE M_wo_idx_space \
	managed by automatic storage \
	initialsize 2G bufferpool M_wo_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching" 

db2 -v "CREATE TABLESPACE M_lo_space \
        managed by automatic storage \
        initialsize 300M bufferpool M_lo_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE M_lo_idx_space \
	managed by automatic storage \
	initialsize 100M bufferpool M_lo_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE M_inv_space \
        managed by automatic storage \
        initialsize 1895M bufferpool M_inv_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE M_inv_idx_space \
	managed by automatic storage \
	initialsize 1110M bufferpool M_inv_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_M.sql
db2 -v connect reset

