#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_O.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2

##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE O_cust_space
db2 -v DROP TABLESPACE O_ords_space
db2 -v DROP TABLESPACE O_ordl_space
db2 -v DROP TABLESPACE O_item_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating O table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v "CREATE TABLESPACE O_cust_space \
        managed by automatic storage \
	initialsize 5M bufferpool O_cust_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE O_ords_space \
        managed by automatic storage \
        initialsize 1024M bufferpool O_ords_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE O_ords_idx_space \
	managed by automatic storage \
	initialsize 1152M bufferpool O_ords_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE O_ordl_space \
        managed by automatic storage \
        initialsize 3474M bufferpool O_ordl_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE O_ordl_idx_space \
	managed by automatic storage \
	initialsize 2328M bufferpool O_ordl_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE O_item_space \
        managed by automatic storage \
        initialsize 192M bufferpool O_item_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE O_item_idx_space \
	managed by automatic storage \
	initialsize 92M bufferpool O_item_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_O.sql
db2 -v connect reset

