#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_S.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2


##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE S_comp_space
db2 -v DROP TABLESPACE S_sc_space
db2 -v DROP TABLESPACE S_po_space
db2 -v DROP TABLESPACE S_site_space
db2 -v DROP TABLESPACE S_supp_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating S table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v "CREATE TABLESPACE S_comp_space \
        managed by automatic storage \
        initialsize 2000M bufferpool S_comp_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE S_comp_idx_space \
	managed by automatic storage \
	initialsize 470M bufferpool S_comp_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE S_sc_space \
        managed by automatic storage \
        initialsize 5700M bufferpool S_sc_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE S_sc_idx_space \
	managed by automatic storage \
	initialsize 13043M bufferpool S_sc_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE S_po_space \
        managed by automatic storage \
        initialsize 124M bufferpool S_po_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE S_pol_space \
	managed by automatic storage \
	initialsize 456M bufferpool S_pol_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE S_po_idx_space \
	managed by automatic storage \
	initialsize 136M bufferpool S_po_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"

db2 -v "CREATE TABLESPACE S_pol_idx_space \
	managed by automatic storage \
	initialsize 600M bufferpool S_pol_idx_bp \
	extentsize 1024K prefetchsize 8K \
	no file system caching"
	
db2 -v "CREATE TABLESPACE S_site_space \
        managed by automatic storage \
	initialsize 8M bufferpool S_site_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE S_site_idx_space \
        managed by automatic storage \
        initialsize 8M bufferpool S_site_idx_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE S_supp_space \
        managed by automatic storage \
	initialsize 8M bufferpool S_supp_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"

db2 -v "CREATE TABLESPACE S_supp_idx_space \
        managed by automatic storage \
        initialsize 8M bufferpool S_supp_idx_bp \
        extentsize 1024K prefetchsize 8K \
        no file system caching"


db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_S.sql
db2 -v connect reset

