#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_U.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2

##############################################
#  clean up tablespaces and
#  datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE U_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating U table space and table..."
# Using SMS for now (until more precise numbers are known)

db2 -v "CREATE TABLESPACE U_space \
       managed by automatic storage \
       initialsize 10M bufferpool U_bp \
       extentsize 1024K prefetchsize 8K \
       no file system caching"

db2 -v "CREATE TABLESPACE U_idx_space \
       managed by automatic storage \
       initialsize 10M bufferpool U_idx_bp \
       extentsize 1024K prefetchsize 8K \
       no file system caching"

db2 -v connect reset

##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_U.sql
db2 -v connect reset

