DROP TABLE O_orders;
CREATE TABLE O_orders
(
        o_id            integer not null,
        o_c_id          integer,
        o_ol_cnt        integer,
        o_discount      numeric(4,2),
        o_total         numeric(12,2),
        o_status        integer,       
        o_entry_date    timestamp,
        o_ship_date     date
)
in O_ords_space index in O_ords_idx_space;

CREATE UNIQUE INDEX O_ords_idx ON O_orders (o_id);
CREATE INDEX O_ord_stat ON O_orders (o_status);
CREATE INDEX O_oc_idx ON O_orders (o_c_id);
CREATE INDEX O_oc_os_idx ON O_orders (o_c_id, o_status);

DROP TABLE O_orderline;
CREATE TABLE O_orderline
(
        ol_id           integer not null,
        ol_o_id         integer not null,
        ol_i_id         char(20),
        ol_qty          integer,
        ol_total_value  numeric(12,2),
        ol_msrp         numeric(12,2),
        ol_status       integer,
        ol_ship_date    date
)
in O_ordl_space index in O_ordl_idx_space;

CREATE UNIQUE INDEX O_ordl_idx ON O_orderline (ol_o_id, ol_id) PCTFREE 90 LEVEL2 PCTFREE 90 PAGE SPLIT HIGH;

DROP TABLE O_item;
CREATE TABLE O_item
(
        i_id                    char(20) not null,
        i_name                  varchar(35),
        i_desc                  varchar(100),
        i_price                 numeric(12,2),
	i_discount		numeric(6,4),
        i_category		integer not null
)
in O_item_space index in O_item_idx_space;

CREATE UNIQUE INDEX O_i_idx ON O_item (i_id) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH;
CREATE INDEX O_icat_idx ON O_item (i_category) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH;

