#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_O.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2

##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE O_cust_space
db2 -v DROP TABLESPACE O_ords_space
db2 -v DROP TABLESPACE O_ordl_space
db2 -v DROP TABLESPACE O_item_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating O table spaces and tables..."

db2 -v "create regular tablespace O_cust_space \
	initialsize 1M bufferpool O_cust_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace O_ords_space \
        initialsize 1024M increasesize 10 percent \
	bufferpool O_ords_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace O_ords_idx_space \
	initialsize 1124M increasesize 10 percent \
	bufferpool O_ords_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace O_ordl_space \
        initialsize 3540M increasesize 10 percent \
	bufferpool O_ordl_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace O_ordl_idx_space \
	initialsize 2674M increasesize 10 percent \
	bufferpool O_ordl_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace O_item_space \
        initialsize 242M bufferpool O_item_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace O_item_idx_space \
	initialsize 115M bufferpool O_item_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_O.sql
db2 -v connect reset

