#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_S.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2


##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE S_comp_space
db2 -v DROP TABLESPACE S_sc_space
db2 -v DROP TABLESPACE S_po_space
db2 -v DROP TABLESPACE S_site_space
db2 -v DROP TABLESPACE S_supp_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating S table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v "create regular tablespace S_comp_space \
        initialsize 3045M bufferpool S_comp_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_comp_idx_space \
	initialsize 600M bufferpool S_comp_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_sc_space \
        initialsize 11210M bufferpool S_sc_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_sc_idx_space \
	initialsize 6162M bufferpool S_sc_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_po_space \
        initialsize 524M increasesize 20 percent \
	bufferpool S_po_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_pol_space \
	initialsize 456M increasesize 20 percent \
	bufferpool S_pol_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_po_idx_space \
	initialsize 136M increasesize 20 percent \
	bufferpool S_po_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_pol_idx_space \
	initialsize 600M increasesize 20 percent \
	bufferpool S_pol_idx_bp \
	extentsize 256 prefetchsize 1M"
	
db2 -v "create regular tablespace S_site_space \
	initialsize 1M bufferpool S_site_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_site_idx_space \
        initialsize 1M bufferpool S_site_idx_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_supp_space \
	initialsize 1M bufferpool S_supp_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace S_supp_idx_space \
        initialsize 1M bufferpool S_supp_idx_bp \
        extentsize 256 prefetchsize 1M"


db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_S.sql
db2 -v connect reset

