#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_C.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2


##############################################
#  clean up tablespaces and
#  datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE C_cust_space
db2 -v DROP TABLESPACE C_supp_space
db2 -v DROP TABLESPACE C_site_space
db2 -v DROP TABLESPACE C_parts_space
db2 -v DROP TABLESPACE C_custinv_space
db2 -v connect reset



##############################################
# Create the required tablespaces
##############################################
echo "Creating C table spaces and tables..."

db2 -v connect to ${DB}
db2 -v "CREATE REGULAR TABLESPACE C_cust_space \
       initialsize 29450M bufferpool C_cust_bp \
       extentsize 256 prefetchsize 1M" 

db2 -v "CREATE REGULAR TABLESPACE C_c_idx_space \
       initialsize 5720M bufferpool C_c_idx_bp \
       extentsize 256 prefetchsize 1M" 

db2 -v "CREATE REGULAR TABLESPACE C_supp_space \
       initialsize 1M bufferpool C_supp_bp \
       extentsize 256 prefetchsize 1M"

db2 -v "CREATE REGULAR TABLESPACE C_supp_idx_space \
       initialsize 1M bufferpool C_supp_idx_bp \
       extentsize 256 prefetchsize 1M" 

db2 -v "CREATE REGULAR TABLESPACE C_site_space \
       initialsize 1M bufferpool C_site_bp \
       extentsize 256 prefetchsize 1M"

db2 -v "CREATE REGULAR TABLESPACE C_site_idx_space \
       initialsize 1M bufferpool C_site_idx_bp \
       extentsize 256 prefetchsize 1M"

db2 -v "CREATE REGULAR TABLESPACE C_parts_space \
        initialsize 3845M bufferpool C_parts_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "CREATE REGULAR TABLESPACE C_p_idx_space \
	initialsize 807M bufferpool C_p_idx_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "CREATE TABLESPACE C_custinv_space \
        initialsize 89600M increasesize 10 percent \
	bufferpool C_ci_bp \
        extentsize 256 prefetchsize 1M" 

db2 -v "CREATE TABLESPACE C_ci_idx_space \
	managed by automatic storage \
	initialsize 74000M increasesize 10 percent \
	bufferpool C_ci_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v connect reset

##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_C.sql
db2 -v connect reset

