#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_M.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2

##############################################
#  clean up datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE M_parts_space
db2 -v DROP TABLESPACE M_bom_space
db2 -v DROP TABLESPACE M_wo_space
db2 -v DROP TABLESPACE M_lo_space
db2 -v DROP TABLESPACE M_inv_space

##############################################
# Create the required tablespaces
##############################################
echo "Creating M table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v "create regular tablespace M_parts_space \
	initialsize 3300M bufferpool M_parts_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_parts_idx_space \
	initialsize 610M bufferpool M_parts_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_bom_space \
        initialsize 3025M bufferpool M_bom_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_bom_idx_space \
	initialsize 1530M bufferpool M_bom_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_wo_space \
        initialsize 2048M increasesize 20 percent \
	bufferpool M_wo_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_wo_idx_space \
	initialsize 500M increasesize 20 percent \
	bufferpool M_wo_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_lo_space \
        initialsize 300M increasesize 20 percent \
	bufferpool M_lo_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_lo_idx_space \
	initialsize 200M increasesize 20 percent \
	bufferpool M_lo_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_inv_space \
        initialsize 1610M bufferpool M_inv_bp \
        extentsize 256 prefetchsize 1M"

db2 -v "create regular tablespace M_inv_idx_space \
	initialsize 615M bufferpool M_inv_idx_bp \
	extentsize 256 prefetchsize 1M"

db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf sql/schema_M.sql
db2 -v connect reset

