#!/bin/ksh
#dd if=/dev/zero of=/dev/rloglv bs=4096k count=21
#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################
db2set DB2_APM_PERFORMANCE=ON 
db2set DB2_KEEPTABLELOCK=CONNECTION
db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2_MINIMIZE_LISTPREFETCH=YES
#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################
db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT off DFT_MON_TIMESTAMP on DFT_MON_UOW on DFT_MON_TABLE off 
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using SVCENAME 60004
db2 -v update dbm cfg using HEALTH_MON off
db2 -v connect to specdb
############################################
# DATABASE CONFIGURATION TUNING            #
############################################
db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using LOGPRIMARY 52
db2 -v update db cfg for specdb using SOFTMAX 3000
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99
db2 -v update db cfg for specdb using LOGFILSIZ 65535 
db2 -v update db cfg for specdb using LOGSECOND 0
db2 -v update db cfg for specdb using LOGPRIMARY 52 
db2 -v update db cfg for specdb using NEWLOGPATH /dev/speclogs/speclogLV 
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using NUM_IOCLEANERS 128 
db2 -v update db cfg for specdb using MAXLOCKS 100 LOCKLIST 100000 
db2 -v update db cfg for specdb using MINCOMMIT 1 
db2 -v update db cfg for specdb using MON_REQ_METRICS none
db2 -v update db cfg for specdb using MON_ACT_METRICS none
db2 -v update db cfg for specdb using MON_OBJ_METRICS none
db2 -v update db cfg for specdb using AUTO_STMT_STATS off
############################################
# BUFFER POOL TUNING                       #
############################################
db2 -v alter bufferpool IBMDEFAULTBP immediate size 19100000  
db2 -v alter bufferpool INDEX_BP immediate size 9130000 
db2 -v alter bufferpool JMS_BP immediate size 2710
db2 -v alter bufferpool M_INV_BP immediate size 202694
db2 -v alter bufferpool M_PARTS_BP immediate size 100352
db2 -v alter bufferpool M_BOM_BP immediate size 25791
db2 -v alter bufferpool M_WO_BP immediate size 30000 
db2 -v alter bufferpool O_ORDERS_BP immediate size 481587 
db2 -v alter bufferpool O_ORDERS2_BP immediate size 321058 
db2 -v alter bufferpool O_OL_BP immediate size 481587 
db2 -v alter bufferpool O_CI_BP immediate size 2584559  
db2 -v alter bufferpool O_CUSTOMER_BP immediate size 1583569
db2 -v alter bufferpool O_ITEM_BP immediate size 3050 
db2 -v alter bufferpool O_ITEM2_BP immediate size 1000 
db2 -v alter bufferpool S_COMPONENT_BP immediate size 481586
db2 -v alter bufferpool S_S_C_BP immediate size 321058
db2 -v alter bufferpool S_P_O_BP immediate size 722380 
db2 -v alter bufferpool S_P_OL_BP immediate size 142693
db2 -v alter bufferpool DATA_BP immediate size 13000000 
############################################
# TABLE TUNING                             #
############################################
db2 -v alter table O_ORDERLINE append on
db2 -v alter table O_CUSTINVENTORY append on
db2 -v alter table O_ORDERS append on
db2 -v alter table S_PURCH_ORDER append on
db2 -v alter table S_PURCH_ORDERLINE append on
db2 -v alter table M_WORKORDER append on
db2 -v alter table M_WORKORDER volatile
db2 -v alter table O_ITEM volatile
db2 -v alter table M_PARTS volatile 
db2 -v alter table M_INVENTORY volatile 
db2 -v terminate
db2set DB2COMM=TCPIP
db2stop force
#dd if=/dev/zero of=/dev/rloglv bs=4096k count=21
db2start
