#!/bin/bash
DB=specdb
DB_DIR=/specjdb
for arg; do export "$arg"; done
MYPATH=$(dirname $(readlink -f $0))
#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################
db2set DB2_COLLECT_TS_REC_INFO=FALSE
db2set DB2_APM_PERFORMANCE=ON
db2set DB2_KEEPTABLELOCK=CONNECTION
db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2_MINIMIZE_LISTPREFETCH=YES
#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################
db2 -v update dbm cfg using DIAGLEVEL 3 
db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK on DFT_MON_SORT on DFT_MON_STMT off DFT_MON_TIMESTAMP on DFT_MON_UOW off  DFT_MON_TABLE on
db2 -v update dbm cfg using MAX_COORDAGENTS 350 automatic
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using HEALTH_MON off
db2 -v connect to $DB
############################################
# DATABASE CONFIGURATION TUNING            #
############################################
db2 -v update db cfg for $DB using LOGBUFSZ 4096
db2 -v update db cfg for $DB using LOGSECOND 0
db2 -v update db cfg for $DB using LOGPRIMARY 256 
db2 -v update db cfg for $DB using SOFTMAX 8080
db2 -v update db cfg for $DB using NEWLOGPATH ${DB_DIR}-log
db2 -v update db cfg for $DB using NUM_IOCLEANERS 16
db2 -v update db cfg for $DB using AUTO_MAINT off
db2 -v update db cfg for $DB using AUTO_RUNSTATS off
db2 -v update db cfg for $DB using AUTO_TBL_MAINT off
db2 -v update db cfg for $DB using LOCKLIST 100000 MAXLOCKS 100
db2 -v update db cfg for $DB using MINCOMMIT 1
db2 -v update db cfg for $DB using MON_REQ_METRICS none
db2 -v update db cfg for $DB using MON_ACT_METRICS none
db2 -v update db cfg for $DB using MON_OBJ_METRICS none
db2 -v update db cfg for $DB using AUTO_STMT_STATS off
db2 -v update db cfg for $DB using AUTO_MAINT off
db2 -v update db cfg for $DB using AUTO_RUNSTATS off
db2 -v update db cfg for $DB using AUTO_TBL_MAINT off
db2 -v update db cfg for $DB using LOGARCHMETH1 off
############################################
# BUFFER POOL TUNING                       #
############################################
############################################
# TABLE TUNING                             #
############################################
db2 -v alter table O_ITEM  volatile
db2 -v alter table S_SUPPLIER volatile
db2 -v alter table M_WORKORDER volatile
db2 -v alter table O_ORDERLINE append on
db2 -v alter table O_CUSTINVENTORY append on
db2 -v alter table O_ORDERS append on
db2 -v alter table S_PURCH_ORDER append on
db2 -v alter table S_PURCH_ORDERLINE append on
db2 -v alter table M_INVENTORY volatile
db2 -v connect reset
