-- This CLP file was created using DB2LOOK Version "10.5" 
-- Timestamp: Mon Mar 31 13:45:47 2014
-- Database Name: SPECDB         
-- Database Manager Version: DB2/AIX64 Version 10.5.3      
-- Database Codepage: 1208
-- Database Collating Sequence is: SYSTEM_819
-- Alternate collating sequence(alt_collate): null
-- varchar2 compatibility(varchar2_compat): OFF


CONNECT TO SPECDB;

------------------------------------
-- DDL Statements for BUFFERPOOLS --
------------------------------------
 
CREATE BUFFERPOOL "SPEC_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "JMS_BP" SIZE AUTOMATIC PAGESIZE 32768;

CREATE BUFFERPOOL "M_INV_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "M_PARTS_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "JMS_IDX_BP" SIZE AUTOMATIC PAGESIZE 32768;

CREATE BUFFERPOOL "M_WO_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "M_WO2_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "M_OL_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_O_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_O2_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_OL_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_CI_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_C_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_ITEM_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "O_ITEM2_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "S_C_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "S_S_C_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "S_S_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "S_P_O_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "S_P_O2_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "S_P_OL_BP" SIZE AUTOMATIC PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI1"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI2"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI3"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI4"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI5"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI6"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI7"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI8"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI9"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI10"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI11"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI12"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI13"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI14"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI15"  SIZE 2000 PAGESIZE 4096;

CREATE BUFFERPOOL "M_BOM_BPI16"  SIZE 2000 PAGESIZE 4096;

CONNECT RESET;
CONNECT TO SPECDB;

--------------------------
-- Mimic Storage groups --
--------------------------
 
ALTER STOGROUP "IBMSTOGROUP"
	 OVERHEAD 6.725000
	 DEVICE READ RATE 100.000000
	 DATA TAG NONE 
	 SET AS DEFAULT;

------------------------------------
-- DDL Statements for TABLESPACES --
------------------------------------


CREATE LARGE TABLESPACE "M_INV_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_INV_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_PARTS_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_PARTS_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "JMS_IDX_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 32768 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 32
	 PREFETCHSIZE 0
	 BUFFERPOOL "JMS_IDX_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_WO_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_WO_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_WO2_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_WO2_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_OL_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_OL_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_O_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_O_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_O2_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_O2_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_OL_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_OL_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_CI_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_CI_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_C_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_C_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_ITEM_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_ITEM_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "O_ITEM2_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "O_ITEM2_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_C_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "S_C_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_S_C_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "S_S_C_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_S_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "S_S_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_P_O_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "S_P_O_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_P_O2_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "S_P_O2_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_P_OL_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "S_P_OL_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "S_R_CONFIG_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "SPEC_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "U_SEQ_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "SPEC_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "U_DS_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "SPEC_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "U_L_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "SPEC_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "U_L_M_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "SPEC_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "U_L_S_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "SPEC_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "JMS_SPACE" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 32768 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 32
	 PREFETCHSIZE 0
	 BUFFERPOOL "JMS_BP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "SYSTOOLSPACE" IN DATABASE PARTITION GROUP IBMCATGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 32 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 4
	 PREFETCHSIZE AUTOMATIC
	 BUFFERPOOL "IBMDEFAULTBP"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I1" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI1"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I2" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI2"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I3" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI3"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I4" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI4"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I5" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI5"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I6" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI6"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I7" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI7"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I8" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI8"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I9" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI9"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I10" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI10"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I11" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI11"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I12" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI12"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I13" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI13"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I14" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI14"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I15" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI15"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


CREATE LARGE TABLESPACE "M_BOM_I16" IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	 PAGESIZE 4096 MANAGED BY AUTOMATIC STORAGE 
	 USING STOGROUP "IBMSTOGROUP" 
	 AUTORESIZE YES 
	 INITIALSIZE 500 M 
	 MAXSIZE NONE 
	 EXTENTSIZE 256
	 PREFETCHSIZE 2
	 BUFFERPOOL "M_BOM_BPI16"
	 DATA TAG INHERIT
	 OVERHEAD INHERIT
	 TRANSFERRATE INHERIT 
	 NO FILE SYSTEM CACHING  
	 DROPPED TABLE RECOVERY ON;


----------------------
-- Mimic tablespace --
----------------------

ALTER TABLESPACE "SYSCATSPACE"
      PREFETCHSIZE AUTOMATIC
      OVERHEAD INHERIT
      NO FILE SYSTEM CACHING 
      AUTORESIZE YES 
      TRANSFERRATE INHERIT;


ALTER TABLESPACE "SYSCATSPACE"
      USING STOGROUP "IBMSTOGROUP"; 


ALTER TABLESPACE "TEMPSPACE1"
      PREFETCHSIZE AUTOMATIC
      OVERHEAD INHERIT
      FILE SYSTEM CACHING 
      TRANSFERRATE INHERIT;


ALTER TABLESPACE "USERSPACE1"
      PREFETCHSIZE AUTOMATIC
      OVERHEAD INHERIT
      NO FILE SYSTEM CACHING 
      AUTORESIZE YES 
      TRANSFERRATE INHERIT
      DATA TAG INHERIT;


ALTER TABLESPACE "USERSPACE1"
      USING STOGROUP "IBMSTOGROUP"; 


------------------------------------------------
-- DDL Statements for Schemas
------------------------------------------------


CREATE SCHEMA "TUL205P6NODE07" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE08" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE09" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE10" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE11" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE12" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE13" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE14" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE15" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE16" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE17" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE18" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE19" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE20" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE21" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE22" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE23" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE24" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE25" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE26" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE27" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE28" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE29" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE30" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE41" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE35" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE42" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE51" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE43" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE39" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE32" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE44" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE45" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE46" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE52" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE31" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE40" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE50" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE54" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE48" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE34" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE37" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE49" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE53" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE47" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE33" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE38" AUTHORIZATION "DB2INST1";

CREATE SCHEMA "TUL205P6NODE36" AUTHORIZATION "DB2INST1";

------------------------------------------------
-- DDL Statements for Schemas
------------------------------------------------

-- Running the DDL below will explicitly create a schema in the
-- new database that corresponds to an implicitly created schema
-- in the original database.

CREATE SCHEMA "DB2INST1";



------------------------------------------------
-- DDL Statements for Table "DB2INST1"."S_SUPPLIER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_SUPPLIER"  (
		  "SUPP_ID" INTEGER NOT NULL , 
		  "SUPP_NAME" CHAR(16 OCTETS) , 
		  "SUPP_STREET1" CHAR(20 OCTETS) , 
		  "SUPP_STREET2" CHAR(20 OCTETS) , 
		  "SUPP_CITY" CHAR(20 OCTETS) , 
		  "SUPP_STATE" CHAR(2 OCTETS) , 
		  "SUPP_COUNTRY" CHAR(10 OCTETS) , 
		  "SUPP_ZIP" CHAR(9 OCTETS) , 
		  "SUPP_PHONE" CHAR(16 OCTETS) , 
		  "SUPP_CONTACT" CHAR(25 OCTETS) , 
		  "SUPP_WS_URL" VARCHAR(128 OCTETS) , 
		  "SUPP_REPLY_URL" VARCHAR(128 OCTETS) , 
		  "SUPP_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" INDEX IN "S_S_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "DB2INST1"."S_SUPPLIER" VOLATILE CARDINALITY;






-- DDL Statements for Indexes on Table "DB2INST1"."S_SUPPLIER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."S_SUPP_IDX" ON "DB2INST1"."S_SUPPLIER" 
		("SUPP_ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."S_RUN_CONFIG"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_RUN_CONFIG"  (
		  "NAME" VARCHAR(20 OCTETS) NOT NULL , 
		  "VALUE" INTEGER NOT NULL )   
		 IN "USERSPACE1" INDEX IN "S_R_CONFIG_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "DB2INST1"."U_SEQUENCES"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_SEQUENCES"  (
		  "S_ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "S_NEXTNUM" INTEGER )   
		 IN "USERSPACE1" INDEX IN "U_SEQ_SPACE"  
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."U_SEQUENCES"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."U_S_IDX" ON "DB2INST1"."U_SEQUENCES" 
		("S_ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."U_DATASEGMENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_DATASEGMENT"  (
		  "DS_ID" VARCHAR(100 OCTETS) NOT NULL , 
		  "DS_BLOB" CLOB(1048576 OCTETS) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" INDEX IN "U_DS_SPACE"  
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."U_DATASEGMENT"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."DS_ID_IDX" ON "DB2INST1"."U_DATASEGMENT" 
		("DS_ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."U_LOADER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOADER"  (
		  "L_TXRATE" INTEGER , 
		  "L_ITEMCOUNT" INTEGER , 
		  "L_ITEMS_PER_TXRATE" INTEGER , 
		  "L_DBIR" INTEGER , 
		  "L_PARALLELISM" INTEGER , 
		  "L_IS_FF" INTEGER , 
		  "L_FF_DIR" VARCHAR(1000 OCTETS) , 
		  "L_FF_DEL" VARCHAR(10 OCTETS) , 
		  "L_IS_STANDALONE" INTEGER , 
		  "L_DB_DRIVER_CLASS" VARCHAR(512 OCTETS) , 
		  "L_DB_URL" VARCHAR(512 OCTETS) , 
		  "L_DB_USER" VARCHAR(512 OCTETS) , 
		  "L_DB_PASSWORD" VARCHAR(512 OCTETS) , 
		  "L_ROOT_SEED" DECIMAL(19,0) , 
		  "L_STATUS" INTEGER , 
		  "L_STARTED_AT" TIMESTAMP , 
		  "L_ENDED_AT" TIMESTAMP , 
		  "L_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" INDEX IN "U_L_SPACE"  
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."U_LOADER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."L_TX_IDX" ON "DB2INST1"."U_LOADER" 
		("L_TXRATE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."U_LOAD_MESSAGE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOAD_MESSAGE"  (
		  "LM_ID" INTEGER , 
		  "LM_TEXT" CLOB(1048576 OCTETS) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" INDEX IN "U_L_M_SPACE"  
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."U_LOAD_MESSAGE"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."LM_ID_IDX" ON "DB2INST1"."U_LOAD_MESSAGE" 
		("LM_ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."U_LOAD_SECTION"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOAD_SECTION"  (
		  "LS_ID" INTEGER , 
		  "LS_DOMAIN" VARCHAR(50 OCTETS) , 
		  "LS_TABLENAMES" VARCHAR(200 OCTETS) , 
		  "LS_SECTION_ID" INTEGER , 
		  "LS_START_STEP" INTEGER , 
		  "LS_NUM_STEPS" INTEGER , 
		  "LS_STATE" INTEGER , 
		  "LS_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" INDEX IN "U_L_S_SPACE"  
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."U_LOAD_SECTION"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."LS_ID_IDX" ON "DB2INST1"."U_LOAD_SECTION" 
		("LS_ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."S_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_COMPONENT"  (
		  "COMP_ID" CHAR(20 OCTETS) NOT NULL , 
		  "COMP_SITE_ID" INTEGER NOT NULL , 
		  "COMP_NAME" CHAR(10 OCTETS) , 
		  "COMP_DESC" VARCHAR(100 OCTETS) , 
		  "COMP_UNIT" CHAR(10 OCTETS) , 
		  "COMP_COST" DECIMAL(12,2) , 
		  "QTY_ON_ORDER" INTEGER , 
		  "QTY_DEMANDED" INTEGER , 
		  "LEAD_TIME" INTEGER , 
		  "CONTAINER_SIZE" INTEGER , 
		  "COMP_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_C_SPACE" PARTITION BY RANGE("COMP_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART13" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART14" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART15" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."S_COMPONENT"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."S_COMP_IDX" ON "DB2INST1"."S_COMPONENT" 
		("COMP_SITE_ID" ASC,
		 "COMP_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."S_SUPP_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_SUPP_COMPONENT"  (
		  "SC_P_ID" CHAR(20 OCTETS) NOT NULL , 
		  "SC_SUPP_ID" INTEGER NOT NULL , 
		  "SC_PRICE" DECIMAL(12,2) , 
		  "SC_QTY" INTEGER , 
		  "SC_DISCOUNT" DECIMAL(6,4) , 
		  "SC_DEL_DATE" INTEGER , 
		  "SC_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_S_C_SPACE" PARTITION BY RANGE("SC_P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART13" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART14" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART15" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."S_SUPP_COMPONENT"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."S_SC_COV_IDX" ON "DB2INST1"."S_SUPP_COMPONENT" 
		("SC_P_ID" ASC,
		 "SC_SUPP_ID" ASC,
		 "SC_PRICE" ASC,
		 "SC_QTY" ASC,
		 "SC_DISCOUNT" ASC,
		 "SC_DEL_DATE" ASC,
		 "SC_VERSION" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."S_SUPP_COMPONENT"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."S_SC_IDX" ON "DB2INST1"."S_SUPP_COMPONENT" 
		("SC_P_ID" ASC,
		 "SC_SUPP_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."M_INVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_INVENTORY"  (
		  "IN_P_ID" CHAR(20 OCTETS) NOT NULL , 
		  "IN_QTY" INTEGER , 
		  "IN_ORDERED" INTEGER , 
		  "IN_LOCATION" INTEGER NOT NULL , 
		  "IN_ACC_CODE" INTEGER , 
		  "IN_ACT_DATE" TIMESTAMP , 
		  "IN_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_INV_SPACE" PARTITION BY RANGE("IN_P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART1" ENDING('00001ABLEA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART2" ENDING('00001ABLEA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART3" ENDING('00001ABLEA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART4" ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART5" ENDING('00001ANTIA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART6" ENDING('00001ANTIA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART7" ENDING('00001ANTIA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART8" ENDING('00001ANTIA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART9" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART10" ENDING('00001ATION0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART11" ENDING('00001ATION0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART12" ENDING('00001ATION0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART13" ENDING('00001ATION0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART14" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART15" ENDING('00001BARAA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART16" ENDING('00001BARAA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART17" ENDING('00001BARAA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART18" ENDING('00001BARAA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART19" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART20" ENDING('00001CALLY0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART21" ENDING('00001CALLY0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART22" ENDING('00001CALLY0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART23" ENDING('00001CALLY0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART24" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART25" ENDING('00001EINGA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART26" ENDING('00001EINGA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART27" ENDING('00001EINGA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART28" ENDING('00001EINGA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART29" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART30" ENDING('00001ESEAA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART31" ENDING('00001ESEAA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART32" ENDING('00001ESEAA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART33" ENDING('00001ESEAA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART34" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART35" ENDING('00001IRESE0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART36" ENDING('00001IRESE0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART37" ENDING('00001IRESE0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART38" ENDING('00001IRESE0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART39" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART40" ENDING('00001LINES0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART41" ENDING('00001LINES0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART42" ENDING('00001LINES0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART43" ENDING('00001LINES0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART44" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART45" ENDING('00001MITEM0000015000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART46" ENDING('00001MITEM0000030000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART47" ENDING('00001MITEM0000045000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART48" ENDING('00001MITEM0000060000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART49" ENDING('00001MITEM0000075000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART50" ENDING('00001NAILS0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART51" ENDING('00001NAILS0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART52" ENDING('00001NAILS0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART53" ENDING('00001NAILS0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART54" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART55" ENDING('00001OUGHT0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART56" ENDING('00001OUGHT0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART57" ENDING('00001OUGHT0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART58" ENDING('00001OUGHT0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART59" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART60" ENDING('00001PRESA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART61" ENDING('00001PRESA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART62" ENDING('00001PRESA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART63" ENDING('00001PRESA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART64" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART65" ENDING('00001PRIAA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART66" ENDING('00001PRIAA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART67" ENDING('00001PRIAA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART68" ENDING('00001PRIAA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART69" ENDING('00001PRIAA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART70" ENDING('00001QUIET0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART71" ENDING('00001QUIET0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART72" ENDING('00001QUIET0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART73" ENDING('00001QUIET0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART74" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART75" ENDING('00001SCREW0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART76" ENDING('00001SCREW0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART77" ENDING('00001SCREW0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART78" ENDING('00001SCREW0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART79" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART80" ENDING('00001SHARE0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART81" ENDING('00001SHARE0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART82" ENDING('00001SHARE0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART83" ENDING('00001SHARE0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART84" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."M_INVENTORY"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."M_INV_COV_IDX" ON "DB2INST1"."M_INVENTORY" 
		("IN_P_ID" ASC,
		 "IN_QTY" ASC,
		 "IN_ORDERED" ASC,
		 "IN_LOCATION" ASC,
		 "IN_ACC_CODE" ASC,
		 "IN_ACT_DATE" ASC,
		 "IN_VERSION" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."M_INVENTORY"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."M_INV_IDX" ON "DB2INST1"."M_INVENTORY" 
		("IN_LOCATION" ASC,
		 "IN_P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."M_PARTS"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_PARTS"  (
		  "P_ID" CHAR(20 OCTETS) NOT NULL , 
		  "P_NAME" CHAR(35 OCTETS) , 
		  "P_DESC" VARCHAR(100 OCTETS) , 
		  "P_REV" CHAR(6 OCTETS) , 
		  "P_PLANNER" INTEGER , 
		  "P_TYPE" INTEGER , 
		  "P_IND" INTEGER , 
		  "P_LOMARK" INTEGER , 
		  "P_HIMARK" INTEGER , 
		  "P_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_PARTS_SPACE" PARTITION BY RANGE("P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART1" ENDING('00001ABLEA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART2" ENDING('00001ABLEA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART3" ENDING('00001ABLEA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART4" ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART5" ENDING('00001ANTIA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART6" ENDING('00001ANTIA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART7" ENDING('00001ANTIA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART8" ENDING('00001ANTIA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART9" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART10" ENDING('00001ATION0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART11" ENDING('00001ATION0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART12" ENDING('00001ATION0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART13" ENDING('00001ATION0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART14" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART15" ENDING('00001BARAA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART16" ENDING('00001BARAA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART17" ENDING('00001BARAA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART18" ENDING('00001BARAA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART19" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART20" ENDING('00001CALLY0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART21" ENDING('00001CALLY0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART22" ENDING('00001CALLY0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART23" ENDING('00001CALLY0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART24" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART25" ENDING('00001EINGA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART26" ENDING('00001EINGA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART27" ENDING('00001EINGA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART28" ENDING('00001EINGA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART29" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART30" ENDING('00001ESEAA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART31" ENDING('00001ESEAA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART32" ENDING('00001ESEAA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART33" ENDING('00001ESEAA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART34" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART35" ENDING('00001IRESE0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART36" ENDING('00001IRESE0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART37" ENDING('00001IRESE0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART38" ENDING('00001IRESE0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART39" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART40" ENDING('00001LINES0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART41" ENDING('00001LINES0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART42" ENDING('00001LINES0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART43" ENDING('00001LINES0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART44" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART45" ENDING('00001MITEM0000015000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART46" ENDING('00001MITEM0000030000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART47" ENDING('00001MITEM0000045000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART48" ENDING('00001MITEM0000060000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART49" ENDING('00001MITEM0000075000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART50" ENDING('00001NAILS0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART51" ENDING('00001NAILS0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART52" ENDING('00001NAILS0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART53" ENDING('00001NAILS0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART54" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART55" ENDING('00001OUGHT0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART56" ENDING('00001OUGHT0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART57" ENDING('00001OUGHT0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART58" ENDING('00001OUGHT0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART59" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART60" ENDING('00001PRESA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART61" ENDING('00001PRESA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART62" ENDING('00001PRESA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART63" ENDING('00001PRESA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART64" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART65" ENDING('00001PRIAA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART66" ENDING('00001PRIAA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART67" ENDING('00001PRIAA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART68" ENDING('00001PRIAA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART69" ENDING('00001PRIAA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART70" ENDING('00001QUIET0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART71" ENDING('00001QUIET0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART72" ENDING('00001QUIET0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART73" ENDING('00001QUIET0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART74" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART75" ENDING('00001SCREW0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART76" ENDING('00001SCREW0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART77" ENDING('00001SCREW0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART78" ENDING('00001SCREW0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART79" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART80" ENDING('00001SHARE0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART81" ENDING('00001SHARE0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART82" ENDING('00001SHARE0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART83" ENDING('00001SHARE0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART84" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."M_PARTS"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."M_PARTS_COV_IDX" ON "DB2INST1"."M_PARTS" 
		("P_ID" ASC,
		 "P_NAME" ASC,
		 "P_DESC" ASC,
		 "P_REV" ASC,
		 "P_PLANNER" ASC,
		 "P_TYPE" ASC,
		 "P_IND" ASC,
		 "P_LOMARK" ASC,
		 "P_HIMARK" ASC,
		 "P_VERSION" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."M_PARTS"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."M_PARTS_IDX" ON "DB2INST1"."M_PARTS" 
		("P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."O_CUSTOMER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_CUSTOMER"  (
		  "C_ID" INTEGER NOT NULL , 
		  "C_FIRST" CHAR(16 OCTETS) , 
		  "C_LAST" CHAR(16 OCTETS) , 
		  "C_STREET1" CHAR(20 OCTETS) , 
		  "C_STREET2" CHAR(20 OCTETS) , 
		  "C_CITY" CHAR(20 OCTETS) , 
		  "C_STATE" CHAR(2 OCTETS) , 
		  "C_COUNTRY" CHAR(10 OCTETS) , 
		  "C_ZIP" CHAR(9 OCTETS) , 
		  "C_PHONE" CHAR(16 OCTETS) , 
		  "C_CONTACT" CHAR(25 OCTETS) , 
		  "C_SINCE" DATE , 
		  "C_BALANCE" DECIMAL(12,2) , 
		  "C_CREDIT" CHAR(2 OCTETS) , 
		  "C_CREDIT_LIMIT" DECIMAL(12,2) , 
		  "C_YTD_PAYMENT" DECIMAL(12,2) , 
		  "C_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_C_SPACE" PARTITION BY RANGE("C_ID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART1" STARTING(5000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART2" STARTING(10000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART3" STARTING(15000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART4" STARTING(20000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART5" STARTING(25000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART6" STARTING(30000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART7" STARTING(35000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART8" STARTING(40000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART9" STARTING(45000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART10" STARTING(50000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART11" STARTING(55000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART12" STARTING(60000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART13" STARTING(65000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART14" STARTING(70000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART15" STARTING(75000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART16" STARTING(80000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART17" STARTING(85000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART18" STARTING(90000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART19" STARTING(95000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART20" STARTING(100000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART21" STARTING(105000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART22" STARTING(110000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART23" STARTING(115000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART24" STARTING(120000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART25" STARTING(125000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART26" STARTING(130000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART27" STARTING(135000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART28" STARTING(140000000) IN "USERSPACE1" INDEX IN "O_C_SPACE", 
		 PART "PART29" STARTING(145000000) ENDING(150000000) IN "USERSPACE1" INDEX IN "O_C_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."O_CUSTOMER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."O_C_IDX" ON "DB2INST1"."O_CUSTOMER" 
		("C_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."O_ITEM"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ITEM"  (
		  "I_ID" CHAR(20 OCTETS) NOT NULL , 
		  "I_NAME" CHAR(35 OCTETS) , 
		  "I_DESC" VARCHAR(100 OCTETS) , 
		  "I_PRICE" DECIMAL(12,2) , 
		  "I_DISCOUNT" DECIMAL(6,4) , 
		  "I_CATEGORY" INTEGER NOT NULL , 
		  "I_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_ITEM2_SPACE" PARTITION BY RANGE("I_ID") 
		 (PART "PART0" STARTING('00001MITEM0000000001') ENDING('00001MITEM0000005000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART1" ENDING('00001MITEM0000010000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART2" ENDING('00001MITEM0000015000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART3" ENDING('00001MITEM0000020000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART4" ENDING('00001MITEM0000025000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART5" ENDING('00001MITEM0000030000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART6" ENDING('00001MITEM0000035000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART7" ENDING('00001MITEM0000040000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART8" ENDING('00001MITEM0000045000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART9" ENDING('00001MITEM0000050000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART10" ENDING('00001MITEM0000055000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART11" ENDING('00001MITEM0000060000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART12" ENDING('00001MITEM0000065000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART13" ENDING('00001MITEM0000070000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART14" ENDING('00001MITEM0000075000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART15" ENDING('00001MITEM0000080000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE") 
		 ORGANIZE BY ROW; 

ALTER TABLE "DB2INST1"."O_ITEM" VOLATILE CARDINALITY;






-- DDL Statements for Indexes on Table "DB2INST1"."O_ITEM"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "DB2INST1"."O_ICAT_IDX" ON "DB2INST1"."O_ITEM" 
		("I_CATEGORY" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."O_ITEM"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."O_I_IDX" ON "DB2INST1"."O_ITEM" 
		("I_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."O_CUSTINVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_CUSTINVENTORY"  (
		  "CI_ID" INTEGER NOT NULL , 
		  "CI_CUSTOMERID" INTEGER NOT NULL , 
		  "CI_ITEMID" CHAR(20 OCTETS) , 
		  "CI_QUANTITY" INTEGER , 
		  "CI_VALUE" DECIMAL(12,2) , 
		  "CI_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_CI_SPACE" PARTITION BY RANGE("CI_CUSTOMERID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART1" STARTING(10000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART2" STARTING(20000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART3" STARTING(30000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART4" STARTING(40000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART5" STARTING(50000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART6" STARTING(60000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART7" STARTING(70000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART8" STARTING(80000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART9" STARTING(90000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART10" STARTING(100000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART11" STARTING(110000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART12" STARTING(120000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART13" STARTING(130000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART14" STARTING(140000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART15" STARTING(150000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART16" STARTING(160000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART17" STARTING(170000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART18" STARTING(180000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART19" STARTING(190000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART20" STARTING(200000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART21" STARTING(210000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART22" STARTING(220000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART23" STARTING(230000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART24" STARTING(240000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART25" STARTING(250000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART26" STARTING(260000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART27" STARTING(270000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART28" STARTING(280000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART29" STARTING(290000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE", 
		 PART "PART30" STARTING(300000000) ENDING(300000000) IN "USERSPACE1" INDEX IN "O_CI_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."O_CUSTINVENTORY"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."O_CI_IDX" ON "DB2INST1"."O_CUSTINVENTORY" 
		("CI_CUSTOMERID" ASC,
		 "CI_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."O_ORDERS"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ORDERS"  (
		  "O_ID" INTEGER NOT NULL , 
		  "O_C_ID" INTEGER , 
		  "O_OL_CNT" INTEGER , 
		  "O_DISCOUNT" DECIMAL(4,2) , 
		  "O_TOTAL" DECIMAL(12,2) , 
		  "O_STATUS" INTEGER , 
		  "O_ENTRY_DATE" TIMESTAMP , 
		  "O_SHIP_DATE" DATE , 
		  "O_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_O2_SPACE" PARTITION BY RANGE("O_C_ID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART1" STARTING(10000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART2" STARTING(20000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART3" STARTING(30000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART4" STARTING(40000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART5" STARTING(50000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART6" STARTING(60000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART7" STARTING(70000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART8" STARTING(80000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART9" STARTING(90000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART10" STARTING(100000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART11" STARTING(110000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART12" STARTING(120000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART13" STARTING(130000000) IN "USERSPACE1" INDEX IN "O_O_SPACE", 
		 PART "PART14" STARTING(140000000) ENDING(150000000) IN "USERSPACE1" INDEX IN "O_O_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."O_ORDERS"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "DB2INST1"."O_OC_IDX" ON "DB2INST1"."O_ORDERS" 
		("O_C_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."O_ORDERS"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."O_ORDS_IDX" ON "DB2INST1"."O_ORDERS" 
		("O_ID" ASC)
		NOT PARTITIONED IN "O_O2_SPACE"
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."S_PURCH_ORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_PURCH_ORDER"  (
		  "PO_NUMBER" INTEGER NOT NULL , 
		  "PO_SITE_ID" INTEGER NOT NULL , 
		  "PO_SUPP_ID" INTEGER , 
		  "PO_POPULAR_SUPP" INTEGER , 
		  "PO_START_DATE" TIMESTAMP , 
		  "PO_SENT_DATE" DATE , 
		  "PO_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_P_O2_SPACE" PARTITION BY RANGE("PO_SITE_ID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART1" STARTING(1) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART2" STARTING(2) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART3" STARTING(3) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART4" STARTING(4) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART5" STARTING(5) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART6" STARTING(6) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART7" STARTING(7) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART8" STARTING(8) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART9" STARTING(9) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART10" STARTING(10) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART11" STARTING(11) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART12" STARTING(12) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART13" STARTING(13) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART14" STARTING(14) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART15" STARTING(15) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART16" STARTING(16) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART17" STARTING(17) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART18" STARTING(18) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART19" STARTING(19) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART20" STARTING(20) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART21" STARTING(21) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART22" STARTING(22) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART23" STARTING(23) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART24" STARTING(24) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART25" STARTING(25) IN "USERSPACE1" INDEX IN "S_P_O_SPACE", 
		 PART "PART26" STARTING(26) ENDING(27) IN "USERSPACE1" INDEX IN "S_P_O_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."S_PURCH_ORDER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "DB2INST1"."S_PODATE_IDX" ON "DB2INST1"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_START_DATE" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."S_PURCH_ORDER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."S_PO_IDX" ON "DB2INST1"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_NUMBER" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."M_WORKORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_WORKORDER"  (
		  "WO_NUMBER" INTEGER NOT NULL , 
		  "WO_LOCATION" INTEGER NOT NULL , 
		  "WO_O_ID" INTEGER , 
		  "WO_OL_ID" INTEGER , 
		  "WO_STATUS" INTEGER , 
		  "WO_ASSEMBLY_ID" CHAR(20 OCTETS) , 
		  "WO_ORIG_QTY" INTEGER , 
		  "WO_COMP_QTY" INTEGER , 
		  "WO_DUE_DATE" TIMESTAMP , 
		  "WO_START_DATE" TIMESTAMP , 
		  "WO_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_WO2_SPACE" PARTITION BY RANGE("WO_NUMBER") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART1" STARTING(280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART2" STARTING(560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART3" STARTING(840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART4" STARTING(1120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART5" STARTING(1400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART6" STARTING(1680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART7" STARTING(1960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART8" STARTING(2240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART9" STARTING(2520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART10" STARTING(2800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART11" STARTING(3080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART12" STARTING(3360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART13" STARTING(3640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART14" STARTING(3920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART15" STARTING(4200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART16" STARTING(4480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART17" STARTING(4760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART18" STARTING(5040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART19" STARTING(5320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART20" STARTING(5600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART21" STARTING(5880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART22" STARTING(6160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART23" STARTING(6440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART24" STARTING(6720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART25" STARTING(7000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART26" STARTING(7280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART27" STARTING(7560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART28" STARTING(7840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART29" STARTING(8120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART30" STARTING(8400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART31" STARTING(8680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART32" STARTING(8960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART33" STARTING(9240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART34" STARTING(9520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART35" STARTING(9800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART36" STARTING(10080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART37" STARTING(10360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART38" STARTING(10640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART39" STARTING(10920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART40" STARTING(11200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART41" STARTING(11480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART42" STARTING(11760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART43" STARTING(12040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART44" STARTING(12320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART45" STARTING(12600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART46" STARTING(12880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART47" STARTING(13160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART48" STARTING(13440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART49" STARTING(13720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART50" STARTING(14000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART51" STARTING(14280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART52" STARTING(14560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART53" STARTING(14840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART54" STARTING(15120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART55" STARTING(15400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART56" STARTING(15680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART57" STARTING(15960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART58" STARTING(16240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART59" STARTING(16520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART60" STARTING(16800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART61" STARTING(17080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART62" STARTING(17360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART63" STARTING(17640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART64" STARTING(17920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART65" STARTING(18200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART66" STARTING(18480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART67" STARTING(18760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART68" STARTING(19040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART69" STARTING(19320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART70" STARTING(19600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART71" STARTING(19880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART72" STARTING(20160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART73" STARTING(20440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART74" STARTING(20720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART75" STARTING(21000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART76" STARTING(21280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART77" STARTING(21560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART78" STARTING(21840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART79" STARTING(22120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART80" STARTING(22400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART81" STARTING(22680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART82" STARTING(22960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART83" STARTING(23240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART84" STARTING(23520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART85" STARTING(23800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART86" STARTING(24080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART87" STARTING(24360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART88" STARTING(24640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART89" STARTING(24920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART90" STARTING(25200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART91" STARTING(25480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART92" STARTING(25760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART93" STARTING(26040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART94" STARTING(26320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART95" STARTING(26600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART96" STARTING(26880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART97" STARTING(27160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART98" STARTING(27440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART99" STARTING(27720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART100" STARTING(28000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART101" STARTING(28280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART102" STARTING(28560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART103" STARTING(28840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART104" STARTING(29120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART105" STARTING(29400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART106" STARTING(29680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART107" STARTING(29960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART108" STARTING(30240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART109" STARTING(30520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART110" STARTING(30800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART111" STARTING(31080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART112" STARTING(31360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART113" STARTING(31640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART114" STARTING(31920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART115" STARTING(32200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART116" STARTING(32480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART117" STARTING(32760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART118" STARTING(33040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART119" STARTING(33320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART120" STARTING(33600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART121" STARTING(33880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART122" STARTING(34160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART123" STARTING(34440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART124" STARTING(34720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART125" STARTING(35000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART126" STARTING(35280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART127" STARTING(35560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART128" STARTING(35840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART129" STARTING(36120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART130" STARTING(36400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART131" STARTING(36680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART132" STARTING(36960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART133" STARTING(37240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART134" STARTING(37520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART135" STARTING(37800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART136" STARTING(38080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART137" STARTING(38360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART138" STARTING(38640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART139" STARTING(38920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART140" STARTING(39200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART141" STARTING(39480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART142" STARTING(39760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART143" STARTING(40040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART144" STARTING(40320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART145" STARTING(40600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART146" STARTING(40880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART147" STARTING(41160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART148" STARTING(41440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART149" STARTING(41720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART150" STARTING(42000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART151" STARTING(42280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART152" STARTING(42560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART153" STARTING(42840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART154" STARTING(43120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART155" STARTING(43400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART156" STARTING(43680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART157" STARTING(43960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART158" STARTING(44240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART159" STARTING(44520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART160" STARTING(44800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART161" STARTING(45080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART162" STARTING(45360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART163" STARTING(45640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART164" STARTING(45920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART165" STARTING(46200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART166" STARTING(46480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART167" STARTING(46760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART168" STARTING(47040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART169" STARTING(47320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART170" STARTING(47600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART171" STARTING(47880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART172" STARTING(48160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART173" STARTING(48440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART174" STARTING(48720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART175" STARTING(49000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART176" STARTING(49280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART177" STARTING(49560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART178" STARTING(49840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART179" STARTING(50120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART180" STARTING(50400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART181" STARTING(50680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART182" STARTING(50960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART183" STARTING(51240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART184" STARTING(51520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART185" STARTING(51800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART186" STARTING(52080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART187" STARTING(52360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART188" STARTING(52640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART189" STARTING(52920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART190" STARTING(53200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART191" STARTING(53480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART192" STARTING(53760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART193" STARTING(54040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART194" STARTING(54320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART195" STARTING(54600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART196" STARTING(54880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART197" STARTING(55160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART198" STARTING(55440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART199" STARTING(55720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART200" STARTING(56000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART201" STARTING(56280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART202" STARTING(56560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART203" STARTING(56840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART204" STARTING(57120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART205" STARTING(57400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART206" STARTING(57680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART207" STARTING(57960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART208" STARTING(58240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART209" STARTING(58520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART210" STARTING(58800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART211" STARTING(59080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART212" STARTING(59360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART213" STARTING(59640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART214" STARTING(59920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART215" STARTING(60200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART216" STARTING(60480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART217" STARTING(60760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART218" STARTING(61040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART219" STARTING(61320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART220" STARTING(61600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART221" STARTING(61880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART222" STARTING(62160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART223" STARTING(62440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART224" STARTING(62720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART225" STARTING(63000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART226" STARTING(63280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART227" STARTING(63560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART228" STARTING(63840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART229" STARTING(64120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART230" STARTING(64400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART231" STARTING(64680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART232" STARTING(64960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART233" STARTING(65240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART234" STARTING(65520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART235" STARTING(65800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART236" STARTING(66080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART237" STARTING(66360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART238" STARTING(66640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART239" STARTING(66920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART240" STARTING(67200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART241" STARTING(67480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART242" STARTING(67760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART243" STARTING(68040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART244" STARTING(68320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART245" STARTING(68600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART246" STARTING(68880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART247" STARTING(69160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART248" STARTING(69440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART249" STARTING(69720000) ENDING(70000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE") 
		 ORGANIZE BY ROW; 

ALTER TABLE "DB2INST1"."M_WORKORDER" VOLATILE CARDINALITY;






-- DDL Statements for Indexes on Table "DB2INST1"."M_WORKORDER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."M_WO_IDX" ON "DB2INST1"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_NUMBER" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;

-- DDL Statements for Indexes on Table "DB2INST1"."M_WORKORDER"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "DB2INST1"."M_WO_OOL_IDX" ON "DB2INST1"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_O_ID" ASC,
		 "WO_OL_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."O_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ORDERLINE"  (
		  "OL_ID" INTEGER NOT NULL , 
		  "OL_O_ID" INTEGER NOT NULL , 
		  "OL_I_ID" CHAR(20 OCTETS) , 
		  "OL_QTY" INTEGER , 
		  "OL_TOTAL_VALUE" DECIMAL(12,2) , 
		  "OL_MSRP" DECIMAL(12,2) , 
		  "OL_STATUS" INTEGER , 
		  "OL_SHIP_DATE" TIMESTAMP , 
		  "OL_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_OL_SPACE" PARTITION BY RANGE("OL_O_ID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART1" STARTING(200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART2" STARTING(400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART3" STARTING(600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART4" STARTING(800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART5" STARTING(1000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART6" STARTING(1200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART7" STARTING(1400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART8" STARTING(1600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART9" STARTING(1800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART10" STARTING(2000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART11" STARTING(2200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART12" STARTING(2400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART13" STARTING(2600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART14" STARTING(2800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART15" STARTING(3000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART16" STARTING(3200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART17" STARTING(3400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART18" STARTING(3600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART19" STARTING(3800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART20" STARTING(4000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART21" STARTING(4200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART22" STARTING(4400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART23" STARTING(4600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART24" STARTING(4800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART25" STARTING(5000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART26" STARTING(5200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART27" STARTING(5400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART28" STARTING(5600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART29" STARTING(5800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART30" STARTING(6000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART31" STARTING(6200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART32" STARTING(6400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART33" STARTING(6600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART34" STARTING(6800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART35" STARTING(7000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART36" STARTING(7200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART37" STARTING(7400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART38" STARTING(7600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART39" STARTING(7800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART40" STARTING(8000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART41" STARTING(8200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART42" STARTING(8400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART43" STARTING(8600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART44" STARTING(8800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART45" STARTING(9000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART46" STARTING(9200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART47" STARTING(9400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART48" STARTING(9600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART49" STARTING(9800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART50" STARTING(10000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART51" STARTING(10200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART52" STARTING(10400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART53" STARTING(10600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART54" STARTING(10800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART55" STARTING(11000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART56" STARTING(11200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART57" STARTING(11400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART58" STARTING(11600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART59" STARTING(11800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART60" STARTING(12000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART61" STARTING(12200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART62" STARTING(12400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART63" STARTING(12600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART64" STARTING(12800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART65" STARTING(13000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART66" STARTING(13200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART67" STARTING(13400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART68" STARTING(13600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART69" STARTING(13800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART70" STARTING(14000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART71" STARTING(14200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART72" STARTING(14400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART73" STARTING(14600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART74" STARTING(14800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART75" STARTING(15000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART76" STARTING(15200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART77" STARTING(15400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART78" STARTING(15600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART79" STARTING(15800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART80" STARTING(16000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART81" STARTING(16200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART82" STARTING(16400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART83" STARTING(16600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART84" STARTING(16800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART85" STARTING(17000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART86" STARTING(17200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART87" STARTING(17400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART88" STARTING(17600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART89" STARTING(17800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART90" STARTING(18000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART91" STARTING(18200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART92" STARTING(18400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART93" STARTING(18600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART94" STARTING(18800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART95" STARTING(19000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART96" STARTING(19200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART97" STARTING(19400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART98" STARTING(19600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART99" STARTING(19800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART100" STARTING(20000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART101" STARTING(20200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART102" STARTING(20400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART103" STARTING(20600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART104" STARTING(20800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART105" STARTING(21000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART106" STARTING(21200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART107" STARTING(21400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART108" STARTING(21600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART109" STARTING(21800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART110" STARTING(22000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART111" STARTING(22200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART112" STARTING(22400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART113" STARTING(22600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART114" STARTING(22800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART115" STARTING(23000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART116" STARTING(23200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART117" STARTING(23400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART118" STARTING(23600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART119" STARTING(23800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART120" STARTING(24000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART121" STARTING(24200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART122" STARTING(24400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART123" STARTING(24600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART124" STARTING(24800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART125" STARTING(25000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART126" STARTING(25200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART127" STARTING(25400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART128" STARTING(25600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART129" STARTING(25800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART130" STARTING(26000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART131" STARTING(26200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART132" STARTING(26400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART133" STARTING(26600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART134" STARTING(26800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART135" STARTING(27000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART136" STARTING(27200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART137" STARTING(27400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART138" STARTING(27600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART139" STARTING(27800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART140" STARTING(28000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART141" STARTING(28200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART142" STARTING(28400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART143" STARTING(28600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART144" STARTING(28800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART145" STARTING(29000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART146" STARTING(29200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART147" STARTING(29400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART148" STARTING(29600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART149" STARTING(29800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART150" STARTING(30000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART151" STARTING(30200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART152" STARTING(30400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART153" STARTING(30600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART154" STARTING(30800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART155" STARTING(31000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART156" STARTING(31200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART157" STARTING(31400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART158" STARTING(31600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART159" STARTING(31800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART160" STARTING(32000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART161" STARTING(32200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART162" STARTING(32400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART163" STARTING(32600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART164" STARTING(32800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART165" STARTING(33000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART166" STARTING(33200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART167" STARTING(33400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART168" STARTING(33600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART169" STARTING(33800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART170" STARTING(34000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART171" STARTING(34200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART172" STARTING(34400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART173" STARTING(34600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART174" STARTING(34800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART175" STARTING(35000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART176" STARTING(35200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART177" STARTING(35400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART178" STARTING(35600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART179" STARTING(35800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART180" STARTING(36000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART181" STARTING(36200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART182" STARTING(36400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART183" STARTING(36600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART184" STARTING(36800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART185" STARTING(37000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART186" STARTING(37200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART187" STARTING(37400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART188" STARTING(37600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART189" STARTING(37800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART190" STARTING(38000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART191" STARTING(38200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART192" STARTING(38400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART193" STARTING(38600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART194" STARTING(38800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART195" STARTING(39000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART196" STARTING(39200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART197" STARTING(39400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART198" STARTING(39600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART199" STARTING(39800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART200" STARTING(40000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART201" STARTING(40200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART202" STARTING(40400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART203" STARTING(40600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART204" STARTING(40800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART205" STARTING(41000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART206" STARTING(41200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART207" STARTING(41400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART208" STARTING(41600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART209" STARTING(41800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART210" STARTING(42000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART211" STARTING(42200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART212" STARTING(42400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART213" STARTING(42600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART214" STARTING(42800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART215" STARTING(43000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART216" STARTING(43200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART217" STARTING(43400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART218" STARTING(43600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART219" STARTING(43800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART220" STARTING(44000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART221" STARTING(44200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART222" STARTING(44400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART223" STARTING(44600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART224" STARTING(44800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART225" STARTING(45000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART226" STARTING(45200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART227" STARTING(45400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART228" STARTING(45600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART229" STARTING(45800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART230" STARTING(46000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART231" STARTING(46200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART232" STARTING(46400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART233" STARTING(46600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART234" STARTING(46800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART235" STARTING(47000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART236" STARTING(47200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART237" STARTING(47400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART238" STARTING(47600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART239" STARTING(47800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART240" STARTING(48000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART241" STARTING(48200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART242" STARTING(48400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART243" STARTING(48600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART244" STARTING(48800000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART245" STARTING(49000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART246" STARTING(49200000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART247" STARTING(49400000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART248" STARTING(49600000) IN "USERSPACE1" INDEX IN "O_OL_SPACE", 
		 PART "PART249" STARTING(49800000) ENDING(50000000) IN "USERSPACE1" INDEX IN "O_OL_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."O_ORDERLINE"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."O_ORDL_IDX" ON "DB2INST1"."O_ORDERLINE" 
		("OL_O_ID" ASC,
		 "OL_ID" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."M_BOM"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_BOM"  (
		  "B_COMP_ID" CHAR(20 OCTETS) NOT NULL , 
		  "B_ASSEMBLY_ID" CHAR(20 OCTETS) NOT NULL , 
		  "B_LINE_NO" INTEGER , 
		  "B_QTY" INTEGER , 
		  "B_OPS" INTEGER , 
		  "B_ENG_CHANGE" CHAR(10 OCTETS) , 
		  "B_OPS_DESC" VARCHAR(100 OCTETS) , 
		  "B_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_BOM_I1" PARTITION BY RANGE("B_COMP_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I1", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I2", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I3", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I4", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I5", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I6", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I7", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I8", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I9", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I10", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I11", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I12", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I13", 
		 PART "PART13" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I14", 
		 PART "PART14" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I15", 
		 PART "PART15" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "M_BOM_I16") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."M_BOM"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."M_BOM_IDX" ON "DB2INST1"."M_BOM" 
		("B_ASSEMBLY_ID" ASC,
		 "B_COMP_ID" ASC,
		 "B_LINE_NO" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "DB2INST1"."S_PURCH_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_PURCH_ORDERLINE"  (
		  "POL_NUMBER" INTEGER NOT NULL , 
		  "POL_PO_ID" INTEGER NOT NULL , 
		  "POL_LOCATION" INTEGER NOT NULL , 
		  "POL_P_ID" CHAR(20 OCTETS) , 
		  "POL_QTY" INTEGER , 
		  "POL_BALANCE" DECIMAL(12,2) , 
		  "POL_LEADTIME" INTEGER WITH DEFAULT 0 , 
		  "POL_DELDATE" DATE , 
		  "POL_MESSAGE" VARCHAR(100 OCTETS) , 
		  "POL_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_P_OL_SPACE" PARTITION BY RANGE("POL_PO_ID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART1" STARTING(200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART2" STARTING(400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART3" STARTING(600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART4" STARTING(800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART5" STARTING(1000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART6" STARTING(1200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART7" STARTING(1400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART8" STARTING(1600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART9" STARTING(1800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART10" STARTING(2000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART11" STARTING(2200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART12" STARTING(2400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART13" STARTING(2600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART14" STARTING(2800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART15" STARTING(3000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART16" STARTING(3200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART17" STARTING(3400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART18" STARTING(3600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART19" STARTING(3800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART20" STARTING(4000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART21" STARTING(4200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART22" STARTING(4400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART23" STARTING(4600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART24" STARTING(4800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART25" STARTING(5000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART26" STARTING(5200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART27" STARTING(5400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART28" STARTING(5600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART29" STARTING(5800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART30" STARTING(6000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART31" STARTING(6200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART32" STARTING(6400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART33" STARTING(6600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART34" STARTING(6800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART35" STARTING(7000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART36" STARTING(7200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART37" STARTING(7400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART38" STARTING(7600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART39" STARTING(7800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART40" STARTING(8000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART41" STARTING(8200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART42" STARTING(8400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART43" STARTING(8600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART44" STARTING(8800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART45" STARTING(9000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART46" STARTING(9200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART47" STARTING(9400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART48" STARTING(9600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART49" STARTING(9800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART50" STARTING(10000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART51" STARTING(10200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART52" STARTING(10400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART53" STARTING(10600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART54" STARTING(10800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART55" STARTING(11000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART56" STARTING(11200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART57" STARTING(11400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART58" STARTING(11600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART59" STARTING(11800000) ENDING(12000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE") 
		 ORGANIZE BY ROW; 






-- DDL Statements for Indexes on Table "DB2INST1"."S_PURCH_ORDERLINE"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "DB2INST1"."S_POL_IDX" ON "DB2INST1"."S_PURCH_ORDERLINE" 
		("POL_LOCATION" ASC,
		 "POL_PO_ID" ASC,
		 "POL_NUMBER" ASC)
		PARTITIONED
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE07"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIBLISTING"

ALTER TABLE "TUL205P6NODE07"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE07"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE07"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE07"."SIB000PKIX" ON "TUL205P6NODE07"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIB000"

ALTER TABLE "TUL205P6NODE07"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE07"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE07"."SIB000STREAMIX" ON "TUL205P6NODE07"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE07"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE07"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE07"."SIB001PKIX" ON "TUL205P6NODE07"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIB001"

ALTER TABLE "TUL205P6NODE07"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE07"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE07"."SIB001STREAMIX" ON "TUL205P6NODE07"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE07"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE07"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE07"."SIB002PKIX" ON "TUL205P6NODE07"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIB002"

ALTER TABLE "TUL205P6NODE07"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE07"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE07"."SIB002STREAMIX" ON "TUL205P6NODE07"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIBKEYS"

ALTER TABLE "TUL205P6NODE07"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE07"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE07"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE07"."SIBXACTS"

ALTER TABLE "TUL205P6NODE07"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE08"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIBLISTING"

ALTER TABLE "TUL205P6NODE08"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE08"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE08"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE08"."SIB000PKIX" ON "TUL205P6NODE08"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIB000"

ALTER TABLE "TUL205P6NODE08"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE08"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE08"."SIB000STREAMIX" ON "TUL205P6NODE08"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE08"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE08"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE08"."SIB001PKIX" ON "TUL205P6NODE08"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIB001"

ALTER TABLE "TUL205P6NODE08"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE08"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE08"."SIB001STREAMIX" ON "TUL205P6NODE08"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE08"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE08"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE08"."SIB002PKIX" ON "TUL205P6NODE08"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIB002"

ALTER TABLE "TUL205P6NODE08"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE08"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE08"."SIB002STREAMIX" ON "TUL205P6NODE08"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIBKEYS"

ALTER TABLE "TUL205P6NODE08"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE08"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE08"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE08"."SIBXACTS"

ALTER TABLE "TUL205P6NODE08"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE09"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIBLISTING"

ALTER TABLE "TUL205P6NODE09"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE09"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE09"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE09"."SIB000PKIX" ON "TUL205P6NODE09"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIB000"

ALTER TABLE "TUL205P6NODE09"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE09"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE09"."SIB000STREAMIX" ON "TUL205P6NODE09"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE09"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE09"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE09"."SIB001PKIX" ON "TUL205P6NODE09"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIB001"

ALTER TABLE "TUL205P6NODE09"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE09"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE09"."SIB001STREAMIX" ON "TUL205P6NODE09"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE09"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE09"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE09"."SIB002PKIX" ON "TUL205P6NODE09"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIB002"

ALTER TABLE "TUL205P6NODE09"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE09"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE09"."SIB002STREAMIX" ON "TUL205P6NODE09"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIBKEYS"

ALTER TABLE "TUL205P6NODE09"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE09"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE09"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE09"."SIBXACTS"

ALTER TABLE "TUL205P6NODE09"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE10"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIBLISTING"

ALTER TABLE "TUL205P6NODE10"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE10"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE10"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE10"."SIB000PKIX" ON "TUL205P6NODE10"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIB000"

ALTER TABLE "TUL205P6NODE10"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE10"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE10"."SIB000STREAMIX" ON "TUL205P6NODE10"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE10"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE10"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE10"."SIB001PKIX" ON "TUL205P6NODE10"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIB001"

ALTER TABLE "TUL205P6NODE10"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE10"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE10"."SIB001STREAMIX" ON "TUL205P6NODE10"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE10"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE10"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE10"."SIB002PKIX" ON "TUL205P6NODE10"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIB002"

ALTER TABLE "TUL205P6NODE10"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE10"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE10"."SIB002STREAMIX" ON "TUL205P6NODE10"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIBKEYS"

ALTER TABLE "TUL205P6NODE10"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE10"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE10"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE10"."SIBXACTS"

ALTER TABLE "TUL205P6NODE10"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE11"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIBLISTING"

ALTER TABLE "TUL205P6NODE11"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE11"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE11"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE11"."SIB000PKIX" ON "TUL205P6NODE11"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIB000"

ALTER TABLE "TUL205P6NODE11"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE11"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE11"."SIB000STREAMIX" ON "TUL205P6NODE11"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE11"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE11"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE11"."SIB001PKIX" ON "TUL205P6NODE11"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIB001"

ALTER TABLE "TUL205P6NODE11"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE11"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE11"."SIB001STREAMIX" ON "TUL205P6NODE11"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE11"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE11"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE11"."SIB002PKIX" ON "TUL205P6NODE11"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIB002"

ALTER TABLE "TUL205P6NODE11"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE11"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE11"."SIB002STREAMIX" ON "TUL205P6NODE11"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIBKEYS"

ALTER TABLE "TUL205P6NODE11"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE11"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE11"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE11"."SIBXACTS"

ALTER TABLE "TUL205P6NODE11"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE12"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIBLISTING"

ALTER TABLE "TUL205P6NODE12"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE12"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE12"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE12"."SIB000PKIX" ON "TUL205P6NODE12"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIB000"

ALTER TABLE "TUL205P6NODE12"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE12"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE12"."SIB000STREAMIX" ON "TUL205P6NODE12"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE12"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE12"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE12"."SIB001PKIX" ON "TUL205P6NODE12"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIB001"

ALTER TABLE "TUL205P6NODE12"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE12"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE12"."SIB001STREAMIX" ON "TUL205P6NODE12"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE12"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE12"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE12"."SIB002PKIX" ON "TUL205P6NODE12"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIB002"

ALTER TABLE "TUL205P6NODE12"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE12"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE12"."SIB002STREAMIX" ON "TUL205P6NODE12"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIBKEYS"

ALTER TABLE "TUL205P6NODE12"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE12"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE12"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE12"."SIBXACTS"

ALTER TABLE "TUL205P6NODE12"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE13"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIBLISTING"

ALTER TABLE "TUL205P6NODE13"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE13"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE13"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE13"."SIB000PKIX" ON "TUL205P6NODE13"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIB000"

ALTER TABLE "TUL205P6NODE13"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE13"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE13"."SIB000STREAMIX" ON "TUL205P6NODE13"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE13"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE13"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE13"."SIB001PKIX" ON "TUL205P6NODE13"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIB001"

ALTER TABLE "TUL205P6NODE13"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE13"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE13"."SIB001STREAMIX" ON "TUL205P6NODE13"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE13"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE13"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE13"."SIB002PKIX" ON "TUL205P6NODE13"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIB002"

ALTER TABLE "TUL205P6NODE13"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE13"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE13"."SIB002STREAMIX" ON "TUL205P6NODE13"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIBKEYS"

ALTER TABLE "TUL205P6NODE13"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE13"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE13"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE13"."SIBXACTS"

ALTER TABLE "TUL205P6NODE13"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE14"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIBLISTING"

ALTER TABLE "TUL205P6NODE14"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE14"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE14"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE14"."SIB000PKIX" ON "TUL205P6NODE14"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIB000"

ALTER TABLE "TUL205P6NODE14"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE14"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE14"."SIB000STREAMIX" ON "TUL205P6NODE14"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE14"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE14"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE14"."SIB001PKIX" ON "TUL205P6NODE14"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIB001"

ALTER TABLE "TUL205P6NODE14"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE14"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE14"."SIB001STREAMIX" ON "TUL205P6NODE14"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE14"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE14"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE14"."SIB002PKIX" ON "TUL205P6NODE14"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIB002"

ALTER TABLE "TUL205P6NODE14"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE14"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE14"."SIB002STREAMIX" ON "TUL205P6NODE14"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIBKEYS"

ALTER TABLE "TUL205P6NODE14"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE14"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE14"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE14"."SIBXACTS"

ALTER TABLE "TUL205P6NODE14"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE15"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIBLISTING"

ALTER TABLE "TUL205P6NODE15"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE15"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE15"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE15"."SIB000PKIX" ON "TUL205P6NODE15"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIB000"

ALTER TABLE "TUL205P6NODE15"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE15"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE15"."SIB000STREAMIX" ON "TUL205P6NODE15"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE15"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE15"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE15"."SIB001PKIX" ON "TUL205P6NODE15"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIB001"

ALTER TABLE "TUL205P6NODE15"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE15"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE15"."SIB001STREAMIX" ON "TUL205P6NODE15"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE15"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE15"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE15"."SIB002PKIX" ON "TUL205P6NODE15"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIB002"

ALTER TABLE "TUL205P6NODE15"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE15"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE15"."SIB002STREAMIX" ON "TUL205P6NODE15"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIBKEYS"

ALTER TABLE "TUL205P6NODE15"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE15"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE15"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE15"."SIBXACTS"

ALTER TABLE "TUL205P6NODE15"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE16"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIBLISTING"

ALTER TABLE "TUL205P6NODE16"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE16"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE16"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE16"."SIB000PKIX" ON "TUL205P6NODE16"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIB000"

ALTER TABLE "TUL205P6NODE16"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE16"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE16"."SIB000STREAMIX" ON "TUL205P6NODE16"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE16"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE16"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE16"."SIB001PKIX" ON "TUL205P6NODE16"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIB001"

ALTER TABLE "TUL205P6NODE16"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE16"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE16"."SIB001STREAMIX" ON "TUL205P6NODE16"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE16"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE16"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE16"."SIB002PKIX" ON "TUL205P6NODE16"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIB002"

ALTER TABLE "TUL205P6NODE16"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE16"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE16"."SIB002STREAMIX" ON "TUL205P6NODE16"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIBKEYS"

ALTER TABLE "TUL205P6NODE16"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE16"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE16"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE16"."SIBXACTS"

ALTER TABLE "TUL205P6NODE16"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE17"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIBLISTING"

ALTER TABLE "TUL205P6NODE17"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE17"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE17"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE17"."SIB000PKIX" ON "TUL205P6NODE17"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIB000"

ALTER TABLE "TUL205P6NODE17"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE17"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE17"."SIB000STREAMIX" ON "TUL205P6NODE17"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE17"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE17"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE17"."SIB001PKIX" ON "TUL205P6NODE17"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIB001"

ALTER TABLE "TUL205P6NODE17"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE17"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE17"."SIB001STREAMIX" ON "TUL205P6NODE17"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE17"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE17"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE17"."SIB002PKIX" ON "TUL205P6NODE17"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIB002"

ALTER TABLE "TUL205P6NODE17"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE17"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE17"."SIB002STREAMIX" ON "TUL205P6NODE17"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIBKEYS"

ALTER TABLE "TUL205P6NODE17"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE17"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE17"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE17"."SIBXACTS"

ALTER TABLE "TUL205P6NODE17"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE18"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIBLISTING"

ALTER TABLE "TUL205P6NODE18"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE18"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE18"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE18"."SIB000PKIX" ON "TUL205P6NODE18"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIB000"

ALTER TABLE "TUL205P6NODE18"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE18"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE18"."SIB000STREAMIX" ON "TUL205P6NODE18"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE18"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE18"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE18"."SIB001PKIX" ON "TUL205P6NODE18"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIB001"

ALTER TABLE "TUL205P6NODE18"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE18"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE18"."SIB001STREAMIX" ON "TUL205P6NODE18"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE18"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE18"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE18"."SIB002PKIX" ON "TUL205P6NODE18"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIB002"

ALTER TABLE "TUL205P6NODE18"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE18"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE18"."SIB002STREAMIX" ON "TUL205P6NODE18"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIBKEYS"

ALTER TABLE "TUL205P6NODE18"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE18"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE18"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE18"."SIBXACTS"

ALTER TABLE "TUL205P6NODE18"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE19"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIBLISTING"

ALTER TABLE "TUL205P6NODE19"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE19"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE19"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE19"."SIB000PKIX" ON "TUL205P6NODE19"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIB000"

ALTER TABLE "TUL205P6NODE19"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE19"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE19"."SIB000STREAMIX" ON "TUL205P6NODE19"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE19"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE19"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE19"."SIB001PKIX" ON "TUL205P6NODE19"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIB001"

ALTER TABLE "TUL205P6NODE19"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE19"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE19"."SIB001STREAMIX" ON "TUL205P6NODE19"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE19"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE19"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE19"."SIB002PKIX" ON "TUL205P6NODE19"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIB002"

ALTER TABLE "TUL205P6NODE19"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE19"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE19"."SIB002STREAMIX" ON "TUL205P6NODE19"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIBKEYS"

ALTER TABLE "TUL205P6NODE19"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE19"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE19"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE19"."SIBXACTS"

ALTER TABLE "TUL205P6NODE19"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE20"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIBLISTING"

ALTER TABLE "TUL205P6NODE20"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE20"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE20"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE20"."SIB000PKIX" ON "TUL205P6NODE20"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIB000"

ALTER TABLE "TUL205P6NODE20"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE20"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE20"."SIB000STREAMIX" ON "TUL205P6NODE20"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE20"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE20"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE20"."SIB001PKIX" ON "TUL205P6NODE20"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIB001"

ALTER TABLE "TUL205P6NODE20"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE20"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE20"."SIB001STREAMIX" ON "TUL205P6NODE20"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE20"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE20"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE20"."SIB002PKIX" ON "TUL205P6NODE20"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIB002"

ALTER TABLE "TUL205P6NODE20"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE20"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE20"."SIB002STREAMIX" ON "TUL205P6NODE20"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIBKEYS"

ALTER TABLE "TUL205P6NODE20"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE20"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE20"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE20"."SIBXACTS"

ALTER TABLE "TUL205P6NODE20"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE21"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIBLISTING"

ALTER TABLE "TUL205P6NODE21"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE21"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE21"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE21"."SIB000PKIX" ON "TUL205P6NODE21"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIB000"

ALTER TABLE "TUL205P6NODE21"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE21"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE21"."SIB000STREAMIX" ON "TUL205P6NODE21"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE21"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE21"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE21"."SIB001PKIX" ON "TUL205P6NODE21"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIB001"

ALTER TABLE "TUL205P6NODE21"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE21"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE21"."SIB001STREAMIX" ON "TUL205P6NODE21"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE21"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE21"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE21"."SIB002PKIX" ON "TUL205P6NODE21"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIB002"

ALTER TABLE "TUL205P6NODE21"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE21"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE21"."SIB002STREAMIX" ON "TUL205P6NODE21"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIBKEYS"

ALTER TABLE "TUL205P6NODE21"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE21"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE21"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE21"."SIBXACTS"

ALTER TABLE "TUL205P6NODE21"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE22"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIBLISTING"

ALTER TABLE "TUL205P6NODE22"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE22"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE22"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE22"."SIB000PKIX" ON "TUL205P6NODE22"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIB000"

ALTER TABLE "TUL205P6NODE22"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE22"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE22"."SIB000STREAMIX" ON "TUL205P6NODE22"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE22"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE22"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE22"."SIB001PKIX" ON "TUL205P6NODE22"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIB001"

ALTER TABLE "TUL205P6NODE22"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE22"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE22"."SIB001STREAMIX" ON "TUL205P6NODE22"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE22"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE22"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE22"."SIB002PKIX" ON "TUL205P6NODE22"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIB002"

ALTER TABLE "TUL205P6NODE22"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE22"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE22"."SIB002STREAMIX" ON "TUL205P6NODE22"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIBKEYS"

ALTER TABLE "TUL205P6NODE22"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE22"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE22"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE22"."SIBXACTS"

ALTER TABLE "TUL205P6NODE22"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE23"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIBLISTING"

ALTER TABLE "TUL205P6NODE23"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE23"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE23"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE23"."SIB000PKIX" ON "TUL205P6NODE23"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIB000"

ALTER TABLE "TUL205P6NODE23"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE23"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE23"."SIB000STREAMIX" ON "TUL205P6NODE23"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE23"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE23"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE23"."SIB001PKIX" ON "TUL205P6NODE23"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIB001"

ALTER TABLE "TUL205P6NODE23"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE23"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE23"."SIB001STREAMIX" ON "TUL205P6NODE23"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE23"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE23"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE23"."SIB002PKIX" ON "TUL205P6NODE23"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIB002"

ALTER TABLE "TUL205P6NODE23"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE23"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE23"."SIB002STREAMIX" ON "TUL205P6NODE23"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIBKEYS"

ALTER TABLE "TUL205P6NODE23"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE23"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE23"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE23"."SIBXACTS"

ALTER TABLE "TUL205P6NODE23"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE24"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIBLISTING"

ALTER TABLE "TUL205P6NODE24"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE24"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE24"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE24"."SIB000PKIX" ON "TUL205P6NODE24"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIB000"

ALTER TABLE "TUL205P6NODE24"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE24"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE24"."SIB000STREAMIX" ON "TUL205P6NODE24"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE24"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE24"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE24"."SIB001PKIX" ON "TUL205P6NODE24"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIB001"

ALTER TABLE "TUL205P6NODE24"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE24"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE24"."SIB001STREAMIX" ON "TUL205P6NODE24"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE24"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE24"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE24"."SIB002PKIX" ON "TUL205P6NODE24"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIB002"

ALTER TABLE "TUL205P6NODE24"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE24"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE24"."SIB002STREAMIX" ON "TUL205P6NODE24"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIBKEYS"

ALTER TABLE "TUL205P6NODE24"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE24"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE24"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE24"."SIBXACTS"

ALTER TABLE "TUL205P6NODE24"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE25"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIBLISTING"

ALTER TABLE "TUL205P6NODE25"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE25"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE25"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE25"."SIB000PKIX" ON "TUL205P6NODE25"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIB000"

ALTER TABLE "TUL205P6NODE25"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE25"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE25"."SIB000STREAMIX" ON "TUL205P6NODE25"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE25"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE25"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE25"."SIB001PKIX" ON "TUL205P6NODE25"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIB001"

ALTER TABLE "TUL205P6NODE25"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE25"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE25"."SIB001STREAMIX" ON "TUL205P6NODE25"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE25"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE25"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE25"."SIB002PKIX" ON "TUL205P6NODE25"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIB002"

ALTER TABLE "TUL205P6NODE25"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE25"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE25"."SIB002STREAMIX" ON "TUL205P6NODE25"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIBKEYS"

ALTER TABLE "TUL205P6NODE25"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE25"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE25"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE25"."SIBXACTS"

ALTER TABLE "TUL205P6NODE25"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE26"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIBLISTING"

ALTER TABLE "TUL205P6NODE26"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE26"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE26"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE26"."SIB000PKIX" ON "TUL205P6NODE26"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIB000"

ALTER TABLE "TUL205P6NODE26"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE26"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE26"."SIB000STREAMIX" ON "TUL205P6NODE26"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE26"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE26"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE26"."SIB001PKIX" ON "TUL205P6NODE26"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIB001"

ALTER TABLE "TUL205P6NODE26"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE26"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE26"."SIB001STREAMIX" ON "TUL205P6NODE26"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE26"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE26"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE26"."SIB002PKIX" ON "TUL205P6NODE26"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIB002"

ALTER TABLE "TUL205P6NODE26"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE26"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE26"."SIB002STREAMIX" ON "TUL205P6NODE26"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIBKEYS"

ALTER TABLE "TUL205P6NODE26"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE26"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE26"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE26"."SIBXACTS"

ALTER TABLE "TUL205P6NODE26"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE27"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIBLISTING"

ALTER TABLE "TUL205P6NODE27"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE27"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE27"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE27"."SIB000PKIX" ON "TUL205P6NODE27"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIB000"

ALTER TABLE "TUL205P6NODE27"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE27"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE27"."SIB000STREAMIX" ON "TUL205P6NODE27"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE27"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE27"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE27"."SIB001PKIX" ON "TUL205P6NODE27"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIB001"

ALTER TABLE "TUL205P6NODE27"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE27"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE27"."SIB001STREAMIX" ON "TUL205P6NODE27"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE27"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE27"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE27"."SIB002PKIX" ON "TUL205P6NODE27"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIB002"

ALTER TABLE "TUL205P6NODE27"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE27"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE27"."SIB002STREAMIX" ON "TUL205P6NODE27"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIBKEYS"

ALTER TABLE "TUL205P6NODE27"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE27"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE27"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE27"."SIBXACTS"

ALTER TABLE "TUL205P6NODE27"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE28"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIBLISTING"

ALTER TABLE "TUL205P6NODE28"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE28"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE28"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE28"."SIB000PKIX" ON "TUL205P6NODE28"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIB000"

ALTER TABLE "TUL205P6NODE28"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE28"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE28"."SIB000STREAMIX" ON "TUL205P6NODE28"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE28"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE28"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE28"."SIB001PKIX" ON "TUL205P6NODE28"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIB001"

ALTER TABLE "TUL205P6NODE28"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE28"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE28"."SIB001STREAMIX" ON "TUL205P6NODE28"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE28"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE28"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE28"."SIB002PKIX" ON "TUL205P6NODE28"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIB002"

ALTER TABLE "TUL205P6NODE28"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE28"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE28"."SIB002STREAMIX" ON "TUL205P6NODE28"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIBKEYS"

ALTER TABLE "TUL205P6NODE28"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE28"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE28"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE28"."SIBXACTS"

ALTER TABLE "TUL205P6NODE28"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE29"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIBLISTING"

ALTER TABLE "TUL205P6NODE29"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE29"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE29"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE29"."SIB000PKIX" ON "TUL205P6NODE29"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIB000"

ALTER TABLE "TUL205P6NODE29"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE29"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE29"."SIB000STREAMIX" ON "TUL205P6NODE29"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE29"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE29"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE29"."SIB001PKIX" ON "TUL205P6NODE29"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIB001"

ALTER TABLE "TUL205P6NODE29"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE29"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE29"."SIB001STREAMIX" ON "TUL205P6NODE29"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE29"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE29"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE29"."SIB002PKIX" ON "TUL205P6NODE29"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIB002"

ALTER TABLE "TUL205P6NODE29"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE29"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE29"."SIB002STREAMIX" ON "TUL205P6NODE29"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIBKEYS"

ALTER TABLE "TUL205P6NODE29"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE29"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE29"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE29"."SIBXACTS"

ALTER TABLE "TUL205P6NODE29"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE30"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIBLISTING"

ALTER TABLE "TUL205P6NODE30"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE30"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE30"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE30"."SIB000PKIX" ON "TUL205P6NODE30"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIB000"

ALTER TABLE "TUL205P6NODE30"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE30"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE30"."SIB000STREAMIX" ON "TUL205P6NODE30"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE30"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE30"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE30"."SIB001PKIX" ON "TUL205P6NODE30"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIB001"

ALTER TABLE "TUL205P6NODE30"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE30"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE30"."SIB001STREAMIX" ON "TUL205P6NODE30"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE30"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Indexes on Table "TUL205P6NODE30"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE UNIQUE INDEX "TUL205P6NODE30"."SIB002PKIX" ON "TUL205P6NODE30"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIB002"

ALTER TABLE "TUL205P6NODE30"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for Indexes on Table "TUL205P6NODE30"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE30"."SIB002STREAMIX" ON "TUL205P6NODE30"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIBKEYS"

ALTER TABLE "TUL205P6NODE30"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE30"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE30"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE30"."SIBXACTS"

ALTER TABLE "TUL205P6NODE30"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16 OCTETS) , 
		  "INC_UUID" VARCHAR(16 OCTETS) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER , 
		  "ME_LUTS" TIMESTAMP , 
		  "ME_INFO" VARCHAR(254 OCTETS) , 
		  "ME_STATUS" VARCHAR(16 OCTETS) )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 





------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE54"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE32"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE44"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE43"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE38"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE40"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE34"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE48"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE50"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE53"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE31"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE41"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE33"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE37"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE51"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE42"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE35"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE52"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE49"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE36"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE47"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE39"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE45"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIBCLASSMAP"

ALTER TABLE "TUL205P6NODE46"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIBLISTING"

ALTER TABLE "TUL205P6NODE41"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIBLISTING"

ALTER TABLE "TUL205P6NODE54"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIBLISTING"

ALTER TABLE "TUL205P6NODE48"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIBLISTING"

ALTER TABLE "TUL205P6NODE44"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIBLISTING"

ALTER TABLE "TUL205P6NODE42"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIBLISTING"

ALTER TABLE "TUL205P6NODE32"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIBLISTING"

ALTER TABLE "TUL205P6NODE38"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIBLISTING"

ALTER TABLE "TUL205P6NODE33"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIBLISTING"

ALTER TABLE "TUL205P6NODE31"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIBLISTING"

ALTER TABLE "TUL205P6NODE37"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIBLISTING"

ALTER TABLE "TUL205P6NODE40"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIBLISTING"

ALTER TABLE "TUL205P6NODE36"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIBLISTING"

ALTER TABLE "TUL205P6NODE35"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIBLISTING"

ALTER TABLE "TUL205P6NODE50"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIBLISTING"

ALTER TABLE "TUL205P6NODE51"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIBLISTING"

ALTER TABLE "TUL205P6NODE49"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIBLISTING"

ALTER TABLE "TUL205P6NODE52"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIBLISTING"

ALTER TABLE "TUL205P6NODE53"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIBLISTING"

ALTER TABLE "TUL205P6NODE47"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIBLISTING"

ALTER TABLE "TUL205P6NODE34"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIBLISTING"

ALTER TABLE "TUL205P6NODE43"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIBLISTING"

ALTER TABLE "TUL205P6NODE39"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIBLISTING"

ALTER TABLE "TUL205P6NODE45"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10 OCTETS) , 
		  "TABLE_NAME" VARCHAR(10 OCTETS) NOT NULL , 
		  "TABLE_TYPE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIBLISTING"

ALTER TABLE "TUL205P6NODE46"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE41"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIB000"

ALTER TABLE "TUL205P6NODE41"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE41"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE41"."SIB000STREAMIX" ON "TUL205P6NODE41"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE54"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIB000"

ALTER TABLE "TUL205P6NODE54"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE54"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE54"."SIB000STREAMIX" ON "TUL205P6NODE54"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE48"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIB000"

ALTER TABLE "TUL205P6NODE48"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE48"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE48"."SIB000STREAMIX" ON "TUL205P6NODE48"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE33"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIB000"

ALTER TABLE "TUL205P6NODE33"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE33"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE33"."SIB000STREAMIX" ON "TUL205P6NODE33"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE44"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIB000"

ALTER TABLE "TUL205P6NODE44"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE44"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE44"."SIB000STREAMIX" ON "TUL205P6NODE44"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE37"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIB000"

ALTER TABLE "TUL205P6NODE37"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE37"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE37"."SIB000STREAMIX" ON "TUL205P6NODE37"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE31"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIB000"

ALTER TABLE "TUL205P6NODE31"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE31"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE31"."SIB000STREAMIX" ON "TUL205P6NODE31"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE42"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIB000"

ALTER TABLE "TUL205P6NODE42"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE42"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE42"."SIB000STREAMIX" ON "TUL205P6NODE42"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE32"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIB000"

ALTER TABLE "TUL205P6NODE32"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE32"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE32"."SIB000STREAMIX" ON "TUL205P6NODE32"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE38"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIB000"

ALTER TABLE "TUL205P6NODE38"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE38"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE38"."SIB000STREAMIX" ON "TUL205P6NODE38"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE35"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIB000"

ALTER TABLE "TUL205P6NODE35"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE35"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE35"."SIB000STREAMIX" ON "TUL205P6NODE35"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE36"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIB000"

ALTER TABLE "TUL205P6NODE36"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE36"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE36"."SIB000STREAMIX" ON "TUL205P6NODE36"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE52"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIB000"

ALTER TABLE "TUL205P6NODE52"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE52"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE52"."SIB000STREAMIX" ON "TUL205P6NODE52"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE50"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIB000"

ALTER TABLE "TUL205P6NODE50"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE50"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE50"."SIB000STREAMIX" ON "TUL205P6NODE50"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE53"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIB000"

ALTER TABLE "TUL205P6NODE53"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE53"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE53"."SIB000STREAMIX" ON "TUL205P6NODE53"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE40"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIB000"

ALTER TABLE "TUL205P6NODE40"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE40"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE40"."SIB000STREAMIX" ON "TUL205P6NODE40"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE49"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIB000"

ALTER TABLE "TUL205P6NODE49"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE49"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE49"."SIB000STREAMIX" ON "TUL205P6NODE49"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE51"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIB000"

ALTER TABLE "TUL205P6NODE51"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE51"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE51"."SIB000STREAMIX" ON "TUL205P6NODE51"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE43"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIB000"

ALTER TABLE "TUL205P6NODE43"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE43"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE43"."SIB000STREAMIX" ON "TUL205P6NODE43"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE47"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIB000"

ALTER TABLE "TUL205P6NODE47"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE47"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE47"."SIB000STREAMIX" ON "TUL205P6NODE47"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE34"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIB000"

ALTER TABLE "TUL205P6NODE34"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE34"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE34"."SIB000STREAMIX" ON "TUL205P6NODE34"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE39"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIB000"

ALTER TABLE "TUL205P6NODE39"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE39"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE39"."SIB000STREAMIX" ON "TUL205P6NODE39"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE45"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIB000"

ALTER TABLE "TUL205P6NODE45"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE45"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE45"."SIB000STREAMIX" ON "TUL205P6NODE45"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIB000"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE46"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIB000"

ALTER TABLE "TUL205P6NODE46"."SIB000" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE46"."SIB000"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE46"."SIB000STREAMIX" ON "TUL205P6NODE46"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE41"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIB001"

ALTER TABLE "TUL205P6NODE41"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE41"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE41"."SIB001STREAMIX" ON "TUL205P6NODE41"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE54"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIB001"

ALTER TABLE "TUL205P6NODE54"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE54"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE54"."SIB001STREAMIX" ON "TUL205P6NODE54"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE48"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIB001"

ALTER TABLE "TUL205P6NODE48"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE48"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE48"."SIB001STREAMIX" ON "TUL205P6NODE48"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE37"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIB001"

ALTER TABLE "TUL205P6NODE37"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE37"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE37"."SIB001STREAMIX" ON "TUL205P6NODE37"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE33"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIB001"

ALTER TABLE "TUL205P6NODE33"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE33"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE33"."SIB001STREAMIX" ON "TUL205P6NODE33"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE42"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIB001"

ALTER TABLE "TUL205P6NODE42"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE42"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE42"."SIB001STREAMIX" ON "TUL205P6NODE42"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE31"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIB001"

ALTER TABLE "TUL205P6NODE31"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE31"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE31"."SIB001STREAMIX" ON "TUL205P6NODE31"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE44"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIB001"

ALTER TABLE "TUL205P6NODE44"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE44"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE44"."SIB001STREAMIX" ON "TUL205P6NODE44"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE36"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIB001"

ALTER TABLE "TUL205P6NODE36"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE36"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE36"."SIB001STREAMIX" ON "TUL205P6NODE36"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE35"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIB001"

ALTER TABLE "TUL205P6NODE35"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE35"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE35"."SIB001STREAMIX" ON "TUL205P6NODE35"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE32"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIB001"

ALTER TABLE "TUL205P6NODE32"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE32"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE32"."SIB001STREAMIX" ON "TUL205P6NODE32"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE53"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIB001"

ALTER TABLE "TUL205P6NODE53"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE53"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE53"."SIB001STREAMIX" ON "TUL205P6NODE53"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE52"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIB001"

ALTER TABLE "TUL205P6NODE52"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE52"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE52"."SIB001STREAMIX" ON "TUL205P6NODE52"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE51"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIB001"

ALTER TABLE "TUL205P6NODE51"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE51"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE51"."SIB001STREAMIX" ON "TUL205P6NODE51"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE38"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIB001"

ALTER TABLE "TUL205P6NODE38"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE38"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE38"."SIB001STREAMIX" ON "TUL205P6NODE38"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE50"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIB001"

ALTER TABLE "TUL205P6NODE50"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE50"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE50"."SIB001STREAMIX" ON "TUL205P6NODE50"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE40"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIB001"

ALTER TABLE "TUL205P6NODE40"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE40"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE40"."SIB001STREAMIX" ON "TUL205P6NODE40"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE49"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIB001"

ALTER TABLE "TUL205P6NODE49"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE49"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE49"."SIB001STREAMIX" ON "TUL205P6NODE49"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE47"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIB001"

ALTER TABLE "TUL205P6NODE47"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE47"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE47"."SIB001STREAMIX" ON "TUL205P6NODE47"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE39"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIB001"

ALTER TABLE "TUL205P6NODE39"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE39"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE39"."SIB001STREAMIX" ON "TUL205P6NODE39"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE43"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIB001"

ALTER TABLE "TUL205P6NODE43"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE43"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE43"."SIB001STREAMIX" ON "TUL205P6NODE43"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE34"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIB001"

ALTER TABLE "TUL205P6NODE34"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE34"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE34"."SIB001STREAMIX" ON "TUL205P6NODE34"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE45"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIB001"

ALTER TABLE "TUL205P6NODE45"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE45"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE45"."SIB001STREAMIX" ON "TUL205P6NODE45"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIB001"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE46"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIB001"

ALTER TABLE "TUL205P6NODE46"."SIB001" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE46"."SIB001"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE46"."SIB001STREAMIX" ON "TUL205P6NODE46"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE41"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIB002"

ALTER TABLE "TUL205P6NODE41"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE41"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE41"."SIB002STREAMIX" ON "TUL205P6NODE41"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE54"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIB002"

ALTER TABLE "TUL205P6NODE54"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE54"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE54"."SIB002STREAMIX" ON "TUL205P6NODE54"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE48"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIB002"

ALTER TABLE "TUL205P6NODE48"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE48"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE48"."SIB002STREAMIX" ON "TUL205P6NODE48"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE37"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIB002"

ALTER TABLE "TUL205P6NODE37"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE37"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE37"."SIB002STREAMIX" ON "TUL205P6NODE37"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE33"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIB002"

ALTER TABLE "TUL205P6NODE33"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE33"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE33"."SIB002STREAMIX" ON "TUL205P6NODE33"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE31"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIB002"

ALTER TABLE "TUL205P6NODE31"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE31"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE31"."SIB002STREAMIX" ON "TUL205P6NODE31"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE42"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIB002"

ALTER TABLE "TUL205P6NODE42"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE42"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE42"."SIB002STREAMIX" ON "TUL205P6NODE42"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE36"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIB002"

ALTER TABLE "TUL205P6NODE36"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE36"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE36"."SIB002STREAMIX" ON "TUL205P6NODE36"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE35"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIB002"

ALTER TABLE "TUL205P6NODE35"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE35"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE35"."SIB002STREAMIX" ON "TUL205P6NODE35"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE32"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIB002"

ALTER TABLE "TUL205P6NODE32"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE32"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE32"."SIB002STREAMIX" ON "TUL205P6NODE32"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE44"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIB002"

ALTER TABLE "TUL205P6NODE44"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE44"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE44"."SIB002STREAMIX" ON "TUL205P6NODE44"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE53"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIB002"

ALTER TABLE "TUL205P6NODE53"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE53"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE53"."SIB002STREAMIX" ON "TUL205P6NODE53"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE51"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIB002"

ALTER TABLE "TUL205P6NODE51"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE51"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE51"."SIB002STREAMIX" ON "TUL205P6NODE51"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE52"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIB002"

ALTER TABLE "TUL205P6NODE52"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE52"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE52"."SIB002STREAMIX" ON "TUL205P6NODE52"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE50"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIB002"

ALTER TABLE "TUL205P6NODE50"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE50"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE50"."SIB002STREAMIX" ON "TUL205P6NODE50"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE39"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIB002"

ALTER TABLE "TUL205P6NODE39"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE39"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE39"."SIB002STREAMIX" ON "TUL205P6NODE39"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE38"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIB002"

ALTER TABLE "TUL205P6NODE38"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE38"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE38"."SIB002STREAMIX" ON "TUL205P6NODE38"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE49"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIB002"

ALTER TABLE "TUL205P6NODE49"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE49"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE49"."SIB002STREAMIX" ON "TUL205P6NODE49"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE47"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIB002"

ALTER TABLE "TUL205P6NODE47"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE47"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE47"."SIB002STREAMIX" ON "TUL205P6NODE47"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE43"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIB002"

ALTER TABLE "TUL205P6NODE43"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE43"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE43"."SIB002STREAMIX" ON "TUL205P6NODE43"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE40"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIB002"

ALTER TABLE "TUL205P6NODE40"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE40"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE40"."SIB002STREAMIX" ON "TUL205P6NODE40"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE34"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIB002"

ALTER TABLE "TUL205P6NODE34"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE34"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE34"."SIB002STREAMIX" ON "TUL205P6NODE34"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE45"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIB002"

ALTER TABLE "TUL205P6NODE45"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE45"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE45"."SIB002STREAMIX" ON "TUL205P6NODE45"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIB002"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2 OCTETS) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360 OCTETS) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254 OCTETS) , 
		  "DELETED" SMALLINT , 
		  "REDELIVERED_COUNT" INTEGER NOT NULL WITH DEFAULT 0 )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 

ALTER TABLE "TUL205P6NODE46"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIB002"

ALTER TABLE "TUL205P6NODE46"."SIB002" 
	ADD PRIMARY KEY
		("ID");



-- DDL Statements for Indexes on Table "TUL205P6NODE46"."SIB002"

SET NLS_STRING_UNITS = 'SYSTEM';

CREATE INDEX "TUL205P6NODE46"."SIB002STREAMIX" ON "TUL205P6NODE46"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO 
		INCLUDE NULL KEYS ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIBKEYS"

ALTER TABLE "TUL205P6NODE41"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIBKEYS"

ALTER TABLE "TUL205P6NODE54"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIBKEYS"

ALTER TABLE "TUL205P6NODE48"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIBKEYS"

ALTER TABLE "TUL205P6NODE37"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIBKEYS"

ALTER TABLE "TUL205P6NODE33"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIBKEYS"

ALTER TABLE "TUL205P6NODE42"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIBKEYS"

ALTER TABLE "TUL205P6NODE31"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIBKEYS"

ALTER TABLE "TUL205P6NODE36"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIBKEYS"

ALTER TABLE "TUL205P6NODE35"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIBKEYS"

ALTER TABLE "TUL205P6NODE44"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIBKEYS"

ALTER TABLE "TUL205P6NODE32"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIBKEYS"

ALTER TABLE "TUL205P6NODE52"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIBKEYS"

ALTER TABLE "TUL205P6NODE53"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIBKEYS"

ALTER TABLE "TUL205P6NODE39"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIBKEYS"

ALTER TABLE "TUL205P6NODE50"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIBKEYS"

ALTER TABLE "TUL205P6NODE51"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIBKEYS"

ALTER TABLE "TUL205P6NODE49"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIBKEYS"

ALTER TABLE "TUL205P6NODE47"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIBKEYS"

ALTER TABLE "TUL205P6NODE38"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIBKEYS"

ALTER TABLE "TUL205P6NODE43"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIBKEYS"

ALTER TABLE "TUL205P6NODE40"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIBKEYS"

ALTER TABLE "TUL205P6NODE34"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIBKEYS"

ALTER TABLE "TUL205P6NODE45"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIBKEYS"  (
		  "ID" VARCHAR(50 OCTETS) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIBKEYS"

ALTER TABLE "TUL205P6NODE46"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE41"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE41"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE41"."SIBXACTS"

ALTER TABLE "TUL205P6NODE41"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE54"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE54"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE54"."SIBXACTS"

ALTER TABLE "TUL205P6NODE54"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE37"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE37"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE37"."SIBXACTS"

ALTER TABLE "TUL205P6NODE37"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE33"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE33"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE33"."SIBXACTS"

ALTER TABLE "TUL205P6NODE33"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE48"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE48"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE48"."SIBXACTS"

ALTER TABLE "TUL205P6NODE48"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE31"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE31"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE31"."SIBXACTS"

ALTER TABLE "TUL205P6NODE31"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE42"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE42"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE42"."SIBXACTS"

ALTER TABLE "TUL205P6NODE42"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE36"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE36"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE36"."SIBXACTS"

ALTER TABLE "TUL205P6NODE36"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE35"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE35"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE35"."SIBXACTS"

ALTER TABLE "TUL205P6NODE35"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE32"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE32"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE32"."SIBXACTS"

ALTER TABLE "TUL205P6NODE32"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE44"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE44"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE44"."SIBXACTS"

ALTER TABLE "TUL205P6NODE44"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE53"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE53"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE53"."SIBXACTS"

ALTER TABLE "TUL205P6NODE53"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE39"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE39"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE39"."SIBXACTS"

ALTER TABLE "TUL205P6NODE39"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE52"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE52"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE52"."SIBXACTS"

ALTER TABLE "TUL205P6NODE52"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE50"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE50"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE50"."SIBXACTS"

ALTER TABLE "TUL205P6NODE50"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE51"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE51"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE51"."SIBXACTS"

ALTER TABLE "TUL205P6NODE51"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE49"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE49"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE49"."SIBXACTS"

ALTER TABLE "TUL205P6NODE49"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE43"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE43"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE43"."SIBXACTS"

ALTER TABLE "TUL205P6NODE43"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE38"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE38"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE38"."SIBXACTS"

ALTER TABLE "TUL205P6NODE38"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE47"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE47"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE47"."SIBXACTS"

ALTER TABLE "TUL205P6NODE47"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE40"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE40"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE40"."SIBXACTS"

ALTER TABLE "TUL205P6NODE40"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE34"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE34"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE34"."SIBXACTS"

ALTER TABLE "TUL205P6NODE34"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE45"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE45"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE45"."SIBXACTS"

ALTER TABLE "TUL205P6NODE45"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for Table "TUL205P6NODE46"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "TUL205P6NODE46"."SIBXACTS"  (
		  "XID" VARCHAR(254 OCTETS) NOT NULL , 
		  "STATE" CHAR(1 OCTETS) NOT NULL )   
		 IN "M_INV_SPACE"  
		 ORGANIZE BY ROW; 


-- DDL Statements for Primary Key on Table "TUL205P6NODE46"."SIBXACTS"

ALTER TABLE "TUL205P6NODE46"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");









COMMIT WORK;

CONNECT RESET;

TERMINATE;

