#!/bin/sh

if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ $# -ne 2 ]
then
        echo "Usage: autoextend.sh <database_name> <database dir>"
        exit 1
fi

DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID

savedir=$cwd
file=/tmp/autoextend_datafiles.sql
>$file
cd $DB_DIR
for i in *
do
    if [ -f $i ]; then
	echo alter database datafile \'$DB_DIR/$i\' autoextend on\; >>$file
    fi
done

sqlplus /nolog<<EOT
connect / as sysdba;
@/tmp/autoextend_datafiles.sql
EOT

#/bin/rm /tmp/autoextend_datafiles.sql
