DROP TABLE M_parts;
CREATE TABLE M_parts
(
	p_id			char(20) ,
	p_name			char(35),
	p_desc			varchar(100),
	p_rev			char(6),
	p_planner		integer,
	p_type			integer,
	p_ind			integer,
	p_lomark		integer,
	p_himark		integer
)
TABLESPACE M_parts_space
;

CREATE UNIQUE INDEX M_parts_idx ON M_parts (p_id)
TABLESPACE M_parts_space
INITRANS 40;

DROP TABLE M_bom;
CREATE TABLE M_bom
(
	b_comp_id		char(20) not null,
	b_assembly_id		char(20) not null,
	b_line_no		integer  not null,
	b_qty			integer,
	b_ops			integer,	
	b_eng_change		char(10),	
	b_ops_desc		varchar(100)
)
TABLESPACE M_bom_space
;

CREATE UNIQUE INDEX M_bom_idx ON M_bom (b_assembly_id, b_comp_id, b_line_no)
TABLESPACE M_bom_space
INITRANS 40;

DROP TABLE M_workorder;
CREATE TABLE M_workorder
(
	wo_number		integer ,
	wo_o_id			integer,
	wo_ol_id		integer,
	wo_status		integer,
	wo_assembly_id	char(20),
	wo_orig_qty		integer,
	wo_comp_qty		integer,
	wo_due_date		date,
	wo_start_date	date
)
partition by hash(wo_number) partitions 43
TABLESPACE M_wo_space
;

CREATE UNIQUE INDEX M_wo_idx ON M_workorder (wo_number)
TABLESPACE M_wo_space
INITRANS 40;

DROP TABLE M_largeorder;
CREATE TABLE M_largeorder
(
	lo_id			integer ,
	lo_o_id			integer,
	lo_ol_id		integer,
	lo_assembly_id	char(20),
	lo_qty			integer,
	lo_due_date		date,
	lo_category             integer
)
partition by hash(lo_id) partitions 43
TABLESPACE M_lo_space
;
CREATE INDEX M_lo_cat_idx ON M_largeorder (lo_category)
TABLESPACE M_lo_space
INITRANS 40 ;

CREATE UNIQUE INDEX M_OL_O_idx ON M_largeorder (lo_o_id, lo_ol_id)
TABLESPACE M_lo_space
INITRANS 40 ;

DROP TABLE M_inventory;
CREATE TABLE M_inventory
(
	in_p_id			char(20) ,
	in_qty			integer,
	in_ordered		integer,
	in_location		char(20),	
	in_acc_code		integer,
	in_act_date		date
)
partition by hash(in_p_id) partitions 40
TABLESPACE M_inv_space
;

CREATE UNIQUE INDEX M_inv_idx ON M_inventory (in_p_id)
TABLESPACE M_inv_space
INITRANS 40;
