#!/bin/ksh



date
export ORACLE_HOME=/export/home/oracle/db
export PATH=$ORACLE_HOME/bin:$ORACLE_HOME/ldap/bin:$ORACLE_HOME/opmn/bin:$PATH
export ORACLE_SID=specdb
export LD_LIBRARY_PATH=$ORACLE_HOME/lib32:$ORACLE_HOME/lib:$LD_LIBRARY_PATH



if [ X$1 != X ]; then
  echo "Analyze Option 1"
  date
  sqlplus / as sysdba <<!
  set serveroutput on
   exec dbms_stats.set_param('ESTIMATE_PERCENT', $1);
  exit;
!
date
else
  echo "Analyze Option 2"
  date
  sqlplus / as sysdba <<!
  set serveroutput on
   exec dbms_stats.set_param('ESTIMATE_PERCENT', DBMS_STATS.AUTO_SAMPLE_SIZE);
  exit;
!
date
fi
date
echo "Now analyzing..."
sqlplus spec04/spec04 <<!
 spool ana.spool;
 set serveroutput on;
 exec dbms_stats.unlock_schema_stats('spec04');
 exec analyse_objs;
 spool off;
 exit;
!
date
