#!/bin/sh
#

PCITOOL=/usr/sbin/pcitool
INO=15

echo "enable intrs on 20x cpus for NICS"
psradm -n 30 486 478 418 392 354 350 290 264 254 200 168 158 104 72 40 484 416 352 288

#
# Retarget the NIC interrupts 
#
$PCITOOL /pci@14,600000 -i ino=$INO -w cpu=1e
$PCITOOL /pci@10,600000 -i ino=$INO -w cpu=1e6
$PCITOOL /pci@54,600000 -i ino=$INO -w cpu=1de
$PCITOOL /pci@50,600000 -i ino=$INO -w cpu=1a2
$PCITOOL /pci@94,600000 -i ino=$INO -w cpu=188
$PCITOOL /pci@70,600000 -i ino=$INO -w cpu=162
$PCITOOL /pci@90,600000 -i ino=$INO -w cpu=15e
$PCITOOL /pci@b0,600000 -i ino=$INO -w cpu=122
$PCITOOL /pci@b4,600000 -i ino=$INO -w cpu=108
$PCITOOL /pci@d0,600000 -i ino=$INO -w cpu=fe
$PCITOOL /pci@40,600000 -i ino=$INO -w cpu=c8
$PCITOOL /pci@44,600000 -i ino=$INO -w cpu=a8
$PCITOOL /pci@60,600000 -i ino=$INO -w cpu=9e
$PCITOOL /pci@64,600000 -i ino=$INO -w cpu=68
$PCITOOL /pci@80,600000 -i ino=$INO -w cpu=48
$PCITOOL /pci@84,600000 -i ino=$INO -w cpu=28
$PCITOOL /pci@c0,600000 -i ino=$INO -w cpu=1e4
$PCITOOL /pci@c4,600000 -i ino=$INO -w cpu=1a0
$PCITOOL /pci@e4,600000 -i ino=$INO -w cpu=160
$PCITOOL /pci@e0,600000 -i ino=$INO -w cpu=120

echo "put 20x NIC intrs & clock intr in a new pset 18"
psrset -c 30 486 478 418 392 354 350 290 264 254 200 168 158 104 72 40 484 416 352 288 32

# Retarget the MPT disk interrupts
#
# REDO LOGS:  d60, d70
$PCITOOL /pci@a6,600000 -i ino=18 -w cpu=1e0
$PCITOOL /pci@86,600000 -i ino=18 -w cpu=1e1
$PCITOOL /pci@a2,600000 -i ino=18 -w cpu=1e0
$PCITOOL /pci@c2,600000 -i ino=18 -w cpu=1e1

$PCITOOL /pci@56,600000 -i ino=18 -w cpu=1e0
$PCITOOL /pci@52,600000 -i ino=18 -w cpu=1e1
$PCITOOL /pci@30,600000 -i ino=18 -w cpu=1e0
$PCITOOL /pci@34,600000 -i ino=18 -w cpu=1e1

# DBFILES: d50 (d52 & d51)
$PCITOOL /pci@e6,600000 -i ino=18 -w cpu=40
$PCITOOL /pci@46,600000 -i ino=18 -w cpu=42
$PCITOOL /pci@42,600000 -i ino=18 -w cpu=44
$PCITOOL /pci@62,600000 -i ino=18 -w cpu=46

$PCITOOL /pci@12,600000 -i ino=18 -w cpu=60
$PCITOOL /pci@16,600000 -i ino=18 -w cpu=62
$PCITOOL /pci@36,600000 -i ino=18 -w cpu=64
$PCITOOL /pci@32,600000 -i ino=18 -w cpu=66

$PCITOOL /pci@92,600000 -i ino=18 -w cpu=a0
$PCITOOL /pci@96,600000 -i ino=18 -w cpu=a2
$PCITOOL /pci@72,600000 -i ino=18 -w cpu=a4
$PCITOOL /pci@76,600000 -i ino=18 -w cpu=a6

$PCITOOL /pci@d4,600000 -i ino=18 -w cpu=c0
$PCITOOL /pci@b2,600000 -i ino=18 -w cpu=c2
$PCITOOL /pci@d6,600000 -i ino=18 -w cpu=c4
$PCITOOL /pci@d2,600000 -i ino=18 -w cpu=c6

