#!/bin/sh
#
MAX_DATA=112
cnt=1
for F in `cat /proc/partitions | grep 29361088 | awk '{print $4}'`
do
        dev=$F
        GUID=`/sbin/scsi_id -g -s /block/$dev`
        SLINK=`echo $GUID | cut -c27-33`
        rm -f data_$SLINK
        ln -s /dev/${dev}1 data_$SLINK
        chown -R oracle:dba /dev/${dev}1
        echo "device $cnt: $dev: $GUID: $SLINK"
        cnt=`expr $cnt + 1`
done

if [ $cnt -lt $MAX_DATA ]; then
        echo "FATAL: detected only $cnt data devices"
fi

# Create raw devices
cnt=1
rcnt=0
for F in `ls -1 data*`
do
        rcnt=`expr $cnt + 100`
        raw /dev/raw/raw${rcnt} $F
        cnt=`expr $cnt + 1`
done

