#!/bin/sh
#
SUDO=sudo
PCITOOL=/usr/sbin/pcitool

# Thus we configure the interrupt binding per chip as follows using
# the following strand offsets:
#
# 7 strands: 0-5,64 for ixgbe fanout
# 5 strands: 65-69 for the ixgbe intrs; 6 8 12 14 4 10 18 16
# 4 strands: 68-69 for mpt interrupts
#

CPU_START=64
CPU_OFF=128
PSET_OFF=64

set -A nexus_arr 300 380 400 480 500 580 600 680
z=0
for I in 6 8 12 14 4 10 18 16
do
	# Get the MSI list for this device for Driver txns
	echo Configuring intrs for ixgbe#${I}
	NEXUS=/pci@${nexus_arr[$z]}
	ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -c ixgbe#${I}`
	set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep ixgbe#${I} | sort +0.10 | awk '{print $3}'`

	# Build the CPU array	                # cpu offset + (chip number X 128)
	CS0=`expr $CPU_START + 1`		# 65
	CS1=`expr $CS0 + 1`			# 66
	CS2=`expr $CS0 + 0`			# 65
	CS3=`expr $CS1 + 0`			# 66
	CS4=`expr $CS0 + 0`			# 65
	CS5=`expr $CS1 + 0`			# 66
	CS6=`expr $CS0 + 0`			# 65
	CS7=`expr $CS1 + 0`			# 66

	echo "Targeted cpus: $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7"
	set -A cpu_arr `printf "%x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x" $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7`

	# Program the CPU binding for this MSI
	i=0
	while [ $i -lt $ino_cnt ] ; do
		$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}
		i=`expr $i + 1`
	done
	
	# Get the MSI list for this device for JDBC txns
	I=`expr $I + 1`
	echo Configuring intrs for ixgbe#${I}
	ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -c ixgbe#${I}`
	set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep ixgbe#${I} | sort +0.10 | awk '{print $3}'`

	# Build the CPU array	                # cpu offset + (chip number X 128)
	CS0=`expr $CPU_START + 3`		# 67
	CS1=`expr $CS0 + 1`			# 68
	CS2=`expr $CS1 + 1`			# 69
	CS3=`expr $CS0 + 0`			# 67
	CS4=`expr $CS1 + 0`			# 68
	CS5=`expr $CS2 + 0`			# 69
	CS6=`expr $CS0 + 0`			# 67
	CS7=`expr $CS1 + 0`			# 68

	echo "Targeted cpus: $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7"
	set -A cpu_arr `printf "%x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x" $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7`

	# Program the CPU binding for this MSI
	i=0
	while [ $i -lt $ino_cnt ] ; do
		$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}
		i=`expr $i + 1`
	done

	z=`expr $z + 1`
	CPU_START=`expr $CPU_START + $CPU_OFF`
done

