#!/bin/ksh

LLR="$ORACLE_HOME/dbs/wlsllr"

sqlplus "/as sysdba" << !
CREATE BIGFILE TABLESPACE wlsllr_ts
       DATAFILE '${LLR}' SIZE 8000M REUSE
       EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
!


# T5-4-001
for x in 31 32 33 34 35 36 37 38  41 42 43 44 45 46 47 48 ; do

sqlplus "spec/spec" << EOT
REM spool WL_LLR_JENT${x}
alter table WL_LLR_JENT${x} enable table lock;
drop table WL_LLR_JENT${x};
CREATE TABLE WL_LLR_JENT${x}
    (
    XIDSTR  VARCHAR2(40) not null,
    POOLNAMESTR VARCHAR2(64),
    RECORDSTR VARCHAR2(1000)
    )
    PARTITION BY HASH (XIDSTR)
    PARTITIONS 32
    STORE IN (wlsllr_ts)
    initrans 30 pctfree 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    CREATE UNIQUE INDEX WL_LLR_JENT${x}_idx ON WL_LLR_JENT${x} (xidstr) LOCAL
    STORE IN (wlsllr_ts)
    INITRANS 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    alter table WL_LLR_JENT${x} disable table lock;
REM spool off
EOT

done
