#!/bin/sh
#
SUDO=sudo
ZNAME=jent

NUM_PSET=5
PSET_MAX=`expr $NUM_PSET + 1`

# Pre-flight check - should have 1x inetd per zone
PCNT=`ps -ef | grep inetd | grep -v grep | wc -l`
if [ $PCNT -lt 9 ]; then
        echo "Some zones not fully functional."
        exit 1
fi

# reset config
PSET=1
while [ $PSET -le $NUM_PSET ];
do
        $SUDO psrset -d $PSET
        PSET=`expr $PSET + 1`
done
$SUDO psradm -an


PSET_START=12
PSET_END=127
PSET_OFF=128
PSET=1
while [ $PSET -le $NUM_PSET ];
do
        echo $SUDO psrset -c ${PSET_START}-${PSET_END}
        $SUDO psrset -c ${PSET_START}-${PSET_END}
        $SUDO psrset -f $PSET
        PSET=`expr $PSET + 1`
        PSET_START=`expr $PSET_START + $PSET_OFF`
        PSET_END=`expr $PSET_END + $PSET_OFF`
done

#
# Now bind the zones
PSET=1
for Z in 31 33 35 37 39
do
        ZONENAME=$ZNAME$Z
        echo "Binding processes in $ZONENAME to processor set $PSET"
        PIDS=`pgrep -z $ZONENAME`
        for P in $PIDS
        do
                $SUDO /usr/sbin/psrset -b $PSET $P
        done

        Z=`expr $Z + 1`
        ZONENAME=$ZNAME$Z
        echo "Binding processes in $ZONENAME to processor set $PSET"
        PIDS=`pgrep -z $ZONENAME`
        for P in $PIDS
        do
                $SUDO /usr/sbin/psrset -b $PSET $P
        done

        PSET=`expr $PSET + 1`
        if [ $PSET -gt $PSET_MAX ]; then
                echo "Error: pset overflow!"
                PSET=1
        fi
done

