name=vg-dbt23
dev1=/dev/vgt23/lvt23db
dev2=/dev/vgt23/lvt23db-data
vnc_port='6235'
monitor_port='13135'
serial_port='14135'
macaddr=00:50:58:78:00:87
alt_macaddr=00:50:59:78:00:87
bridge=br0
cpus=1
mem=2048
numactl --preferred=7 --cpunodebind=7  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=dbt23,ifname=dbt23,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=dbt23,mac=$macaddr\
    -pcidevice host=0e:17.5\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
