name=vg-dbt26
dev1=/dev/vgt26/lvt26db
dev2=/dev/vgt26/lvt26db-data
vnc_port='6253'
monitor_port='13153'
serial_port='14153'
macaddr=00:50:58:78:00:99
alt_macaddr=00:50:59:78:00:99
bridge=br0
cpus=1
mem=2048
numactl --preferred=2 --cpunodebind=2  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=dbt26,ifname=dbt26,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=dbt26,mac=$macaddr\
    -pcidevice host=0e:1a.5\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
