#!/bin/bash

# if eth1 exists, and it is a ixgbevf device, then
# get eth0 ip/route, ifdown eth0, and configure
# eth1 with eth0's IP

if [ -e /sys/class/net/eth1 ]; then
   eth0_ip=`ip addr show dev eth0 | grep "inet " | awk '{print $2}' | awk -F/ '{print $1}'`
   if [ -z "$eth0_ip" ]; then
	echo "no ip address for eth0, exiting"
        exit 1
   fi
   def_route_gw=`ip route show | grep default | awk '{print $3}'`
   echo migrating eth0 ip $eth0_ip to eth2
   ifdown eth0
   ifconfig eth1 down
   ifconfig eth1 $eth0_ip netmask 255.255.0.0 up
   route add -net default gw $def_route_gw dev eth1
fi 
