!Crown Copyright 2012 AWE.
!
! This file is part of CloverLeaf.
!
! CloverLeaf is free software: you can redistribute it and/or modify it under 
! the terms of the GNU General Public License as published by the 
! Free Software Foundation, either version 3 of the License, or (at your option) 
! any later version.
!
! CloverLeaf is distributed in the hope that it will be useful, but 
! WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
! FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
! details.
!
! You should have received a copy of the GNU General Public License along with 
! CloverLeaf. If not, see http://www.gnu.org/licenses/.

!>  @brief Driver for the viscosity kernels
!>  @author Wayne Gaudin
!>  @details Selects the user specified kernel to caluclate the artificial 
!>  viscosity.

MODULE viscosity_module

CONTAINS

SUBROUTINE calc_viscosity(c)

  USE clover_module
  USE viscosity_kernel_module
  
  IMPLICIT NONE

  INTEGER :: c

    CALL viscosity_kernel(chunks(c)%field%x_min,                   &
                        chunks(c)%field%x_max,                     &
                        chunks(c)%field%y_min,                     &
                        chunks(c)%field%y_max,                     &
                        chunks(c)%field%celldx,                    &
                        chunks(c)%field%celldy,                    &
                        chunks(c)%field%density0,                  &
                        chunks(c)%field%pressure,                  &
                        chunks(c)%field%viscosity,                 &
                        chunks(c)%field%xvel0,                     &
                        chunks(c)%field%yvel0                      )
  

END SUBROUTINE calc_viscosity

END MODULE viscosity_module
