/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;

public class SettingsRate
implements Serializable {
    public final boolean auto;
    public final int minThreads;
    public final int maxThreads;
    public final int threadCount;
    public final int opRateTargetPerSecond;

    public SettingsRate(ThreadOptions options) {
        this.auto = false;
        this.threadCount = Integer.parseInt(options.threads.value());
        String rateOpt = options.rate.value();
        this.opRateTargetPerSecond = Integer.parseInt(rateOpt.substring(0, rateOpt.length() - 2));
        this.minThreads = -1;
        this.maxThreads = -1;
    }

    public SettingsRate(AutoOptions auto) {
        this.auto = auto.auto.setByUser();
        this.minThreads = Integer.parseInt(auto.minThreads.value());
        this.maxThreads = Integer.parseInt(auto.maxThreads.value());
        this.threadCount = -1;
        this.opRateTargetPerSecond = 0;
    }

    public static SettingsRate get(Map<String, String[]> clArgs, SettingsCommand command) {
        String[] params = clArgs.remove("-rate");
        if (params == null) {
            switch (command.type) {
                case WRITE: 
                case COUNTER_WRITE: {
                    if (command.count <= 0L) break;
                    ThreadOptions options = new ThreadOptions();
                    options.accept("threads=200");
                    return new SettingsRate(options);
                }
            }
            AutoOptions options = new AutoOptions();
            options.accept("auto");
            return new SettingsRate(options);
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new GroupedOptions[]{new AutoOptions(), new ThreadOptions()});
        if (options == null) {
            SettingsRate.printHelp();
            System.out.println("Invalid -rate options provided, see output for valid options");
            System.exit(1);
        }
        if (options instanceof AutoOptions) {
            return new SettingsRate((AutoOptions)options);
        }
        if (options instanceof ThreadOptions) {
            return new SettingsRate((ThreadOptions)options);
        }
        throw new IllegalStateException();
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-rate", new ThreadOptions(), new AutoOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsRate.printHelp();
            }
        };
    }

    private static final class ThreadOptions
    extends GroupedOptions {
        final OptionSimple threads = new OptionSimple("threads=", "[0-9]+", null, "run this many clients concurrently", true);
        final OptionSimple rate = new OptionSimple("limit=", "[0-9]+/s", "0/s", "limit operations per second across all clients", false);

        private ThreadOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.threads, this.rate);
        }
    }

    private static final class AutoOptions
    extends GroupedOptions {
        final OptionSimple auto = new OptionSimple("auto", "", null, "stop increasing threads once throughput saturates", false);
        final OptionSimple minThreads = new OptionSimple("threads>=", "[0-9]+", "4", "run at least this many clients concurrently", false);
        final OptionSimple maxThreads = new OptionSimple("threads<=", "[0-9]+", "1000", "run at most this many clients concurrently", false);

        private AutoOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.minThreads, this.maxThreads, this.auto);
        }
    }
}

