/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.hadoop.AbstractBulkOutputFormat;
import org.apache.cassandra.hadoop.cql3.CqlBulkRecordWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;

public class CqlBulkOutputFormat
extends AbstractBulkOutputFormat<Object, List<ByteBuffer>> {
    private static final String OUTPUT_CQL_SCHEMA_PREFIX = "cassandra.columnfamily.schema.";
    private static final String OUTPUT_CQL_INSERT_PREFIX = "cassandra.columnfamily.insert.";
    private static final String DELETE_SOURCE = "cassandra.output.delete.source";
    private static final String OUTPUT_CQL_STORAGE_PORT = "cassandra.storage.port";
    private static final String OUTPUT_CQL_SSL_STORAGE_PORT = "cassandra.ssl.storage.port";
    private static final String INTERNODE_ENCRYPTION = "cassandra.internode.encryption";
    private static final String SERVER_KEYSTORE = "cassandra.server.keystore";
    private static final String SERVER_KEYSTORE_PASSWORD = "cassandra.server.keystore.password";
    private static final String SERVER_TRUSTSTORE = "cassandra.server.truststore";
    private static final String SERVER_TRUSTSTORE_PASSWORD = "cassandra.server.truststore.password";
    private static final String SERVER_CIPHER_SUITES = "cassandra.server.truststore.password";
    public static final int DEFAULT_STORAGE_PORT = 7000;
    public static final int DEFAULT_SSL_STORAGE_PORT = 7001;

    @Deprecated
    public CqlBulkRecordWriter getRecordWriter(FileSystem filesystem, JobConf job, String name, Progressable progress) throws IOException {
        return new CqlBulkRecordWriter((Configuration)job, progress);
    }

    public CqlBulkRecordWriter getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new CqlBulkRecordWriter(context);
    }

    public static void setColumnFamilySchema(Configuration conf, String columnFamily, String schema) {
        conf.set(OUTPUT_CQL_SCHEMA_PREFIX + columnFamily, schema);
    }

    public static void setColumnFamilyInsertStatement(Configuration conf, String columnFamily, String insertStatement) {
        conf.set(OUTPUT_CQL_INSERT_PREFIX + columnFamily, insertStatement);
    }

    public static void setStoragePort(Configuration conf, int port) {
        conf.set(OUTPUT_CQL_STORAGE_PORT, "" + port);
    }

    public static void setSSLStoragePort(Configuration conf, int port) {
        conf.set(OUTPUT_CQL_SSL_STORAGE_PORT, "" + port);
    }

    public static void setInternodeEncryption(Configuration conf, String encrypt) {
        conf.set(INTERNODE_ENCRYPTION, encrypt);
    }

    public static void setServerKeystore(Configuration conf, String keystore) {
        conf.set(SERVER_KEYSTORE, keystore);
    }

    public static void setServerKeystorePassword(Configuration conf, String keystorePass) {
        conf.set(SERVER_KEYSTORE_PASSWORD, keystorePass);
    }

    public static void setServerTruststore(Configuration conf, String truststore) {
        conf.set(SERVER_TRUSTSTORE, truststore);
    }

    public static void setServerTruststorePassword(Configuration conf, String truststorePass) {
        conf.set("cassandra.server.truststore.password", truststorePass);
    }

    public static void setServerCipherSuites(Configuration conf, String cipherSuites) {
        conf.set("cassandra.server.truststore.password", cipherSuites);
    }

    public static int getStoragePort(Configuration conf) {
        return conf.getInt(OUTPUT_CQL_STORAGE_PORT, 7000);
    }

    public static int getSSLStoragePort(Configuration conf) {
        return conf.getInt(OUTPUT_CQL_SSL_STORAGE_PORT, 7001);
    }

    public static String getInternodeEncryption(Configuration conf) {
        return conf.get(INTERNODE_ENCRYPTION, EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none.name());
    }

    public static String getServerKeystore(Configuration conf) {
        return conf.get(SERVER_KEYSTORE);
    }

    public static String getServerTruststore(Configuration conf) {
        return conf.get(SERVER_TRUSTSTORE);
    }

    public static String getServerKeystorePassword(Configuration conf) {
        return conf.get(SERVER_KEYSTORE_PASSWORD);
    }

    public static String getServerTruststorePassword(Configuration conf) {
        return conf.get("cassandra.server.truststore.password");
    }

    public static String getServerCipherSuites(Configuration conf) {
        return conf.get("cassandra.server.truststore.password");
    }

    public static String getColumnFamilySchema(Configuration conf, String columnFamily) {
        String schema = conf.get(OUTPUT_CQL_SCHEMA_PREFIX + columnFamily);
        if (schema == null) {
            throw new UnsupportedOperationException("You must set the ColumnFamily schema using setColumnFamilySchema.");
        }
        return schema;
    }

    public static String getColumnFamilyInsertStatement(Configuration conf, String columnFamily) {
        String insert = conf.get(OUTPUT_CQL_INSERT_PREFIX + columnFamily);
        if (insert == null) {
            throw new UnsupportedOperationException("You must set the ColumnFamily insert statement using setColumnFamilySchema.");
        }
        return insert;
    }

    public static void setDeleteSourceOnSuccess(Configuration conf, boolean deleteSrc) {
        conf.setBoolean(DELETE_SOURCE, deleteSrc);
    }

    public static boolean getDeleteSourceOnSuccess(Configuration conf) {
        return conf.getBoolean(DELETE_SOURCE, false);
    }
}

