/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.thrift.ThriftClientState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(ThriftSessionManager.class);
    public static final ThriftSessionManager instance = new ThriftSessionManager();
    private final ThreadLocal<SocketAddress> remoteSocket = new ThreadLocal();
    private final ConcurrentHashMap<SocketAddress, ThriftClientState> activeSocketSessions = new ConcurrentHashMap();

    public void setCurrentSocket(SocketAddress socket) {
        this.remoteSocket.set(socket);
    }

    public ThriftClientState currentSession() {
        ThriftClientState newState;
        SocketAddress socket = this.remoteSocket.get();
        assert (socket != null);
        ThriftClientState cState = this.activeSocketSessions.get(socket);
        if (cState == null && (cState = this.activeSocketSessions.putIfAbsent(socket, newState = new ThriftClientState(socket))) == null) {
            cState = newState;
        }
        return cState;
    }

    public void connectionComplete(SocketAddress socket) {
        assert (socket != null);
        this.activeSocketSessions.remove(socket);
        if (logger.isTraceEnabled()) {
            logger.trace("ClientState removed for socket addr {}", (Object)socket);
        }
    }

    public int getConnectedClients() {
        return this.activeSocketSessions.size();
    }
}

