/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;

public class PoolingOptions {
    private static final int DEFAULT_MIN_REQUESTS = 25;
    private static final int DEFAULT_MAX_REQUESTS = 100;
    private static final int DEFAULT_CORE_POOL_LOCAL = 8;
    private static final int DEFAULT_CORE_POOL_REMOTE = 2;
    private static final int DEFAULT_MAX_POOL_LOCAL = 8;
    private static final int DEFAULT_MAX_POOL_REMOTE = 2;
    private static final int DEFAULT_POOL_TIMEOUT_MILLIS = 5000;
    private volatile Cluster.Manager manager;
    private final int[] minSimultaneousRequests = new int[]{25, 25, 0};
    private final int[] maxSimultaneousRequests = new int[]{100, 100, 0};
    private final int[] coreConnections = new int[]{8, 2, 0};
    private final int[] maxConnections = new int[]{8, 2, 0};
    private volatile int poolTimeoutMillis = 5000;

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getMinSimultaneousRequestsPerConnectionThreshold(HostDistance distance) {
        return this.minSimultaneousRequests[distance.ordinal()];
    }

    public synchronized PoolingOptions setMinSimultaneousRequestsPerConnectionThreshold(HostDistance distance, int newMinSimultaneousRequests) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set min simultaneous requests per connection threshold for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkRequestsPerConnectionRange(newMinSimultaneousRequests, "Min simultaneous requests per connection", distance);
        PoolingOptions.checkRequestsPerConnectionOrder(newMinSimultaneousRequests, this.maxSimultaneousRequests[distance.ordinal()], distance);
        this.minSimultaneousRequests[distance.ordinal()] = newMinSimultaneousRequests;
        return this;
    }

    public int getMaxSimultaneousRequestsPerConnectionThreshold(HostDistance distance) {
        return this.maxSimultaneousRequests[distance.ordinal()];
    }

    public synchronized PoolingOptions setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance distance, int newMaxSimultaneousRequests) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set max simultaneous requests per connection threshold for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkRequestsPerConnectionRange(newMaxSimultaneousRequests, "Max simultaneous requests per connection", distance);
        PoolingOptions.checkRequestsPerConnectionOrder(this.minSimultaneousRequests[distance.ordinal()], newMaxSimultaneousRequests, distance);
        this.maxSimultaneousRequests[distance.ordinal()] = newMaxSimultaneousRequests;
        return this;
    }

    public int getCoreConnectionsPerHost(HostDistance distance) {
        return this.coreConnections[distance.ordinal()];
    }

    public synchronized PoolingOptions setCoreConnectionsPerHost(HostDistance distance, int newCoreConnections) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set core connections per host for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkConnectionsPerHostOrder(newCoreConnections, this.maxConnections[distance.ordinal()], distance);
        int oldCore = this.coreConnections[distance.ordinal()];
        this.coreConnections[distance.ordinal()] = newCoreConnections;
        if (oldCore < newCoreConnections && this.manager != null) {
            this.manager.ensurePoolsSizing();
        }
        return this;
    }

    public int getMaxConnectionsPerHost(HostDistance distance) {
        return this.maxConnections[distance.ordinal()];
    }

    public synchronized PoolingOptions setMaxConnectionsPerHost(HostDistance distance, int newMaxConnections) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set max connections per host for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkConnectionsPerHostOrder(this.coreConnections[distance.ordinal()], newMaxConnections, distance);
        this.maxConnections[distance.ordinal()] = newMaxConnections;
        return this;
    }

    public int getPoolTimeoutMillis() {
        return this.poolTimeoutMillis;
    }

    public PoolingOptions setPoolTimeoutMillis(int poolTimeoutMillis) {
        if (poolTimeoutMillis < 0) {
            throw new IllegalArgumentException("Pool timeout must be positive");
        }
        this.poolTimeoutMillis = poolTimeoutMillis;
        return this;
    }

    public void refreshConnectedHosts() {
        this.manager.refreshConnectedHosts();
    }

    public void refreshConnectedHost(Host host) {
        this.manager.refreshConnectedHost(host);
    }

    private static void checkRequestsPerConnectionRange(int value, String description, HostDistance distance) {
        if (value < 0 || value > 128) {
            throw new IllegalArgumentException(String.format("%s for %s hosts must be in the range (0, %d)", new Object[]{description, distance, 128}));
        }
    }

    private static void checkRequestsPerConnectionOrder(int min, int max, HostDistance distance) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("Min simultaneous requests per connection for %s hosts must be less than max (%d > %d)", new Object[]{distance, min, max}));
        }
    }

    private static void checkConnectionsPerHostOrder(int core, int max, HostDistance distance) {
        if (core > max) {
            throw new IllegalArgumentException(String.format("Core connections for %s hosts must be less than max (%d > %d)", new Object[]{distance, core, max}));
        }
    }
}

