/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.SSLOptions;

public class ProtocolOptions {
    public static final int DEFAULT_PORT = 9042;
    public static final int DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = 10;
    private volatile Cluster.Manager manager;
    private final int port;
    final int initialProtocolVersion;
    private final int maxSchemaAgreementWaitSeconds;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;
    private volatile Compression compression = Compression.NONE;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this(port, -1, 10, null, AuthProvider.NONE);
    }

    public ProtocolOptions(int port, int protocolVersion, int maxSchemaAgreementWaitSeconds, SSLOptions sslOptions, AuthProvider authProvider) {
        this.port = port;
        this.initialProtocolVersion = protocolVersion;
        this.maxSchemaAgreementWaitSeconds = maxSchemaAgreementWaitSeconds;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
        if (protocolVersion >= 0 && protocolVersion != 1 && protocolVersion != 2) {
            throw new IllegalArgumentException(String.format("Unsupported protocol version %d; valid values are 1, 2 or negative (for auto-detect).", protocolVersion));
        }
    }

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocolVersion() {
        return this.manager.connectionFactory.protocolVersion;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public int getMaxSchemaAgreementWaitSeconds() {
        return this.maxSchemaAgreementWaitSeconds;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public static enum Compression {
        NONE("", null),
        SNAPPY("snappy", FrameCompressor.SnappyCompressor.instance),
        LZ4("lz4", FrameCompressor.LZ4Compressor.instance);

        final String protocolName;
        final FrameCompressor compressor;

        private Compression(String protocolName, FrameCompressor compressor) {
            this.protocolName = protocolName;
            this.compressor = compressor;
        }

        FrameCompressor compressor() {
            return this.compressor;
        }

        static Compression fromString(String str) {
            for (Compression c : Compression.values()) {
                if (!c.protocolName.equalsIgnoreCase(str)) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

