/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.spdy;

import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.datastax.shaded.netty.channel.ChannelDownstreamHandler;
import com.datastax.shaded.netty.channel.ChannelEvent;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.ChannelFutureListener;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.DownstreamMessageEvent;
import com.datastax.shaded.netty.channel.MessageEvent;
import com.datastax.shaded.netty.handler.codec.http.HttpChunk;
import com.datastax.shaded.netty.handler.codec.http.HttpChunkTrailer;
import com.datastax.shaded.netty.handler.codec.http.HttpHeaders;
import com.datastax.shaded.netty.handler.codec.http.HttpMessage;
import com.datastax.shaded.netty.handler.codec.http.HttpRequest;
import com.datastax.shaded.netty.handler.codec.http.HttpResponse;
import com.datastax.shaded.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import com.datastax.shaded.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import com.datastax.shaded.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import com.datastax.shaded.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyDataFrame;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyHeaders;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyHttpHeaders;
import com.datastax.shaded.netty.handler.codec.spdy.SpdySynReplyFrame;
import com.datastax.shaded.netty.handler.codec.spdy.SpdySynStreamFrame;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyVersion;
import java.net.SocketAddress;
import java.util.Map;

public class SpdyHttpEncoder
implements ChannelDownstreamHandler {
    private final int spdyVersion;
    private volatile int currentStreamId;

    public SpdyHttpEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.spdyVersion = spdyVersion.getVersion();
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            this.currentStreamId = spdySynStreamFrame.getStreamId();
            ChannelFuture future = this.getMessageFuture(ctx, e, this.currentStreamId, httpRequest);
            Channels.write(ctx, future, spdySynStreamFrame, e.getRemoteAddress());
        } else if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            if (httpResponse.headers().contains("X-SPDY-Associated-To-Stream-ID")) {
                SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpResponse);
                this.currentStreamId = spdySynStreamFrame.getStreamId();
                ChannelFuture future = this.getMessageFuture(ctx, e, this.currentStreamId, httpResponse);
                Channels.write(ctx, future, spdySynStreamFrame, e.getRemoteAddress());
            } else {
                SpdySynReplyFrame spdySynReplyFrame = this.createSynReplyFrame(httpResponse);
                this.currentStreamId = spdySynReplyFrame.getStreamId();
                ChannelFuture future = this.getMessageFuture(ctx, e, this.currentStreamId, httpResponse);
                Channels.write(ctx, future, spdySynReplyFrame, e.getRemoteAddress());
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            this.writeChunk(ctx, e.getFuture(), this.currentStreamId, chunk, e.getRemoteAddress());
        } else {
            ctx.sendDownstream(evt);
        }
    }

    protected void writeChunk(ChannelHandlerContext ctx, ChannelFuture future, int streamId, HttpChunk chunk, SocketAddress remoteAddress) {
        if (chunk.isLast()) {
            if (chunk instanceof HttpChunkTrailer) {
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                HttpHeaders trailers = trailer.trailingHeaders();
                if (trailers.isEmpty()) {
                    DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
                    spdyDataFrame.setLast(true);
                    Channels.write(ctx, future, spdyDataFrame, remoteAddress);
                } else {
                    DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(streamId);
                    spdyHeadersFrame.setLast(true);
                    for (Map.Entry entry : trailers) {
                        spdyHeadersFrame.headers().add((String)entry.getKey(), entry.getValue());
                    }
                    Channels.write(ctx, future, spdyHeadersFrame, remoteAddress);
                }
            } else {
                DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
                spdyDataFrame.setLast(true);
                Channels.write(ctx, future, spdyDataFrame, remoteAddress);
            }
        } else {
            SpdyDataFrame[] spdyDataFrames = this.createSpdyDataFrames(streamId, chunk.getContent());
            ChannelFuture dataFuture = SpdyHttpEncoder.getDataFuture(ctx, future, spdyDataFrames, remoteAddress);
            dataFuture.setSuccess();
        }
    }

    private ChannelFuture getMessageFuture(ChannelHandlerContext ctx, MessageEvent e, int streamId, HttpMessage httpMessage) {
        if (!httpMessage.getContent().readable()) {
            return e.getFuture();
        }
        SpdyDataFrame[] spdyDataFrames = this.createSpdyDataFrames(streamId, httpMessage.getContent());
        if (spdyDataFrames.length > 0) {
            spdyDataFrames[spdyDataFrames.length - 1].setLast(true);
        }
        return SpdyHttpEncoder.getDataFuture(ctx, e.getFuture(), spdyDataFrames, e.getRemoteAddress());
    }

    private static ChannelFuture getDataFuture(ChannelHandlerContext ctx, ChannelFuture future, SpdyDataFrame[] spdyDataFrames, SocketAddress remoteAddress) {
        ChannelFuture dataFuture = future;
        int i = spdyDataFrames.length;
        while (--i >= 0) {
            future = Channels.future(ctx.getChannel());
            future.addListener(new SpdyFrameWriter(ctx, new DownstreamMessageEvent(ctx.getChannel(), dataFuture, spdyDataFrames[i], remoteAddress)));
            dataFuture = future;
        }
        return dataFuture;
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpMessage httpMessage) throws Exception {
        boolean chunked = httpMessage.isChunked();
        int streamId = SpdyHttpHeaders.getStreamId(httpMessage);
        int associatedToStreamId = SpdyHttpHeaders.getAssociatedToStreamId(httpMessage);
        byte priority = SpdyHttpHeaders.getPriority(httpMessage);
        String URL2 = SpdyHttpHeaders.getUrl(httpMessage);
        String scheme = SpdyHttpHeaders.getScheme(httpMessage);
        SpdyHttpHeaders.removeStreamId(httpMessage);
        SpdyHttpHeaders.removeAssociatedToStreamId(httpMessage);
        SpdyHttpHeaders.removePriority(httpMessage);
        SpdyHttpHeaders.removeUrl(httpMessage);
        SpdyHttpHeaders.removeScheme(httpMessage);
        httpMessage.headers().remove("Connection");
        httpMessage.headers().remove("Keep-Alive");
        httpMessage.headers().remove("Proxy-Connection");
        httpMessage.headers().remove("Transfer-Encoding");
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, associatedToStreamId, priority);
        spdySynStreamFrame.setLast(!chunked && !httpMessage.getContent().readable());
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            SpdyHeaders.setMethod(this.spdyVersion, spdySynStreamFrame, httpRequest.getMethod());
            SpdyHeaders.setUrl(this.spdyVersion, spdySynStreamFrame, httpRequest.getUri());
            SpdyHeaders.setVersion(this.spdyVersion, spdySynStreamFrame, httpMessage.getProtocolVersion());
        }
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            SpdyHeaders.setStatus(this.spdyVersion, spdySynStreamFrame, httpResponse.getStatus());
            SpdyHeaders.setUrl(this.spdyVersion, spdySynStreamFrame, URL2);
            SpdyHeaders.setVersion(this.spdyVersion, spdySynStreamFrame, httpMessage.getProtocolVersion());
            spdySynStreamFrame.setUnidirectional(true);
        }
        String host = HttpHeaders.getHost(httpMessage);
        httpMessage.headers().remove("Host");
        SpdyHeaders.setHost(spdySynStreamFrame, host);
        if (scheme == null) {
            scheme = "https";
        }
        SpdyHeaders.setScheme(this.spdyVersion, spdySynStreamFrame, scheme);
        for (Map.Entry entry : httpMessage.headers()) {
            spdySynStreamFrame.headers().add((String)entry.getKey(), entry.getValue());
        }
        return spdySynStreamFrame;
    }

    private SpdySynReplyFrame createSynReplyFrame(HttpResponse httpResponse) throws Exception {
        boolean chunked = httpResponse.isChunked();
        int streamId = SpdyHttpHeaders.getStreamId(httpResponse);
        SpdyHttpHeaders.removeStreamId(httpResponse);
        httpResponse.headers().remove("Connection");
        httpResponse.headers().remove("Keep-Alive");
        httpResponse.headers().remove("Proxy-Connection");
        httpResponse.headers().remove("Transfer-Encoding");
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
        spdySynReplyFrame.setLast(!chunked && !httpResponse.getContent().readable());
        SpdyHeaders.setStatus(this.spdyVersion, spdySynReplyFrame, httpResponse.getStatus());
        SpdyHeaders.setVersion(this.spdyVersion, spdySynReplyFrame, httpResponse.getProtocolVersion());
        for (Map.Entry entry : httpResponse.headers()) {
            spdySynReplyFrame.headers().add((String)entry.getKey(), entry.getValue());
        }
        return spdySynReplyFrame;
    }

    private SpdyDataFrame[] createSpdyDataFrames(int streamId, ChannelBuffer content) {
        int readableBytes = content.readableBytes();
        int count = readableBytes / 0xFFFFFF;
        if (readableBytes % 0xFFFFFF > 0) {
            ++count;
        }
        SpdyDataFrame[] spdyDataFrames = new SpdyDataFrame[count];
        for (int i = 0; i < count; ++i) {
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
            int dataSize = Math.min(content.readableBytes(), 0xFFFFFF);
            spdyDataFrame.setData(content.readSlice(dataSize));
            spdyDataFrames[i] = spdyDataFrame;
        }
        return spdyDataFrames;
    }

    private static class SpdyFrameWriter
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final MessageEvent e;

        SpdyFrameWriter(ChannelHandlerContext ctx, MessageEvent e) {
            this.ctx = ctx;
            this.e = e;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.ctx.sendDownstream(this.e);
            } else if (future.isCancelled()) {
                this.e.getFuture().cancel();
            } else {
                this.e.getFuture().setFailure(future.getCause());
            }
        }
    }
}

