/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.timeout;

import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.handler.timeout.IdleState;
import com.datastax.shaded.netty.handler.timeout.IdleStateEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class DefaultIdleStateEvent
implements IdleStateEvent {
    private final Channel channel;
    private final IdleState state;
    private final long lastActivityTimeMillis;

    public DefaultIdleStateEvent(Channel channel, IdleState state, long lastActivityTimeMillis) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.channel = channel;
        this.state = state;
        this.lastActivityTimeMillis = lastActivityTimeMillis;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public IdleState getState() {
        return this.state;
    }

    public long getLastActivityTimeMillis() {
        return this.lastActivityTimeMillis;
    }

    public String toString() {
        return this.getChannel().toString() + ' ' + (Object)((Object)this.getState()) + " since " + DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date(this.getLastActivityTimeMillis()));
    }
}

