/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ConfiguredYarnAuthorizer;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;

public class AdminService
extends CompositeService
implements HAServiceProtocol,
ResourceManagerAdministrationProtocol {
    private static final Log LOG = LogFactory.getLog(AdminService.class);
    private final RMContext rmContext;
    private final ResourceManager rm;
    private String rmId;
    private boolean autoFailoverEnabled;
    private EmbeddedElectorService embeddedElector;
    private RPC.Server server;
    private InetSocketAddress masterServiceBindAddress;
    private YarnAuthorizationProvider authorizer;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private UserGroupInformation daemonUser;

    public AdminService(ResourceManager rm, RMContext rmContext) {
        super(AdminService.class.getName());
        this.rm = rm;
        this.rmContext = rmContext;
    }

    public void serviceInit(Configuration conf) throws Exception {
        if (this.rmContext.isHAEnabled()) {
            this.autoFailoverEnabled = HAUtil.isAutomaticFailoverEnabled((Configuration)conf);
            if (this.autoFailoverEnabled && HAUtil.isAutomaticFailoverEmbedded((Configuration)conf)) {
                this.embeddedElector = this.createEmbeddedElectorService();
                this.addIfService((Object)this.embeddedElector);
            }
        }
        this.masterServiceBindAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        this.daemonUser = UserGroupInformation.getCurrentUser();
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        this.authorizer.setAdmins(this.getAdminAclList(conf), UserGroupInformation.getCurrentUser());
        this.rmId = conf.get("yarn.resourcemanager.ha.id");
        super.serviceInit(conf);
    }

    private AccessControlList getAdminAclList(Configuration conf) {
        AccessControlList aclList = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        aclList.addUser(this.daemonUser.getShortUserName());
        return aclList;
    }

    protected void serviceStart() throws Exception {
        this.startServer();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopServer();
        super.serviceStop();
    }

    protected void startServer() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = (RPC.Server)rpc.getServer(ResourceManagerAdministrationProtocol.class, (Object)this, this.masterServiceBindAddress, conf, null, conf.getInt("yarn.resourcemanager.admin.client.thread-count", 1));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(this.getConfiguration(conf, "hadoop-policy.xml"), RMPolicyProvider.getInstance());
        }
        if (this.rmContext.isHAEnabled()) {
            RPC.setProtocolEngine((Configuration)conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
            HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this);
            BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
            this.server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, HAServiceProtocol.class, (Object)haPbService);
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.admin.address", "0.0.0.0:8033", this.server.getListenerAddress());
    }

    protected void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected EmbeddedElectorService createEmbeddedElectorService() {
        return new EmbeddedElectorService(this.rmContext);
    }

    @InterfaceAudience.Private
    void resetLeaderElection() {
        if (this.embeddedElector != null) {
            this.embeddedElector.resetLeaderElection();
        }
    }

    private UserGroupInformation checkAccess(String method) throws IOException {
        return RMServerUtils.verifyAdminAccess(this.authorizer, method, LOG);
    }

    private UserGroupInformation checkAcls(String method) throws YarnException {
        try {
            return this.checkAccess(method);
        }
        catch (IOException ioe) {
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    private void checkHaStateChange(HAServiceProtocol.StateChangeRequestInfo req) throws AccessControlException {
        switch (req.getSource()) {
            case REQUEST_BY_USER: {
                if (!this.autoFailoverEnabled) break;
                throw new AccessControlException("Manual failover for this ResourceManager is disallowed, because automatic failover is enabled.");
            }
            case REQUEST_BY_USER_FORCED: {
                if (!this.autoFailoverEnabled) break;
                LOG.warn((Object)("Allowing manual failover from " + Server.getRemoteAddress() + " even though automatic failover is enabled, because the user " + "specified the force flag"));
                break;
            }
            case REQUEST_BY_ZKFC: {
                if (this.autoFailoverEnabled) break;
                throw new AccessControlException("Request from ZK failover controller at " + Server.getRemoteAddress() + " denied " + "since automatic failover is not enabled");
            }
        }
    }

    private synchronized boolean isRMActive() {
        return HAServiceProtocol.HAServiceState.ACTIVE == this.rmContext.getHAServiceState();
    }

    private void throwStandbyException() throws StandbyException {
        throw new StandbyException("ResourceManager " + this.rmId + " is not Active!");
    }

    public synchronized void monitorHealth() throws IOException {
        this.checkAccess("monitorHealth");
        if (this.isRMActive() && !this.rm.areActiveServicesRunning()) {
            throw new HealthCheckFailedException("Active ResourceManager services are not running!");
        }
    }

    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            this.refreshAdminAcls(false);
        }
        catch (YarnException ex) {
            throw new ServiceFailedException("Can not execute refreshAdminAcls", (Throwable)ex);
        }
        UserGroupInformation user = this.checkAccess("transitionToActive");
        this.checkHaStateChange(reqInfo);
        try {
            this.rm.transitionToActive();
            this.refreshAll();
            RMAuditLogger.logSuccess(user.getShortUserName(), "transitionToActive", "RMHAProtocolService");
        }
        catch (Exception e) {
            RMAuditLogger.logFailure(user.getShortUserName(), "transitionToActive", "", "RMHAProtocolService", "Exception transitioning to active");
            throw new ServiceFailedException("Error when transitioning to Active mode", (Throwable)e);
        }
    }

    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            this.refreshAdminAcls(false);
        }
        catch (YarnException ex) {
            throw new ServiceFailedException("Can not execute refreshAdminAcls", (Throwable)ex);
        }
        UserGroupInformation user = this.checkAccess("transitionToStandby");
        this.checkHaStateChange(reqInfo);
        try {
            this.rm.transitionToStandby(true);
            RMAuditLogger.logSuccess(user.getShortUserName(), "transitionToStandby", "RMHAProtocolService");
        }
        catch (Exception e) {
            RMAuditLogger.logFailure(user.getShortUserName(), "transitionToStandby", "", "RMHAProtocolService", "Exception transitioning to standby");
            throw new ServiceFailedException("Error when transitioning to Standby mode", (Throwable)e);
        }
    }

    public synchronized HAServiceStatus getServiceStatus() throws IOException {
        this.checkAccess("getServiceState");
        HAServiceProtocol.HAServiceState haState = this.rmContext.getHAServiceState();
        HAServiceStatus ret = new HAServiceStatus(haState);
        if (this.isRMActive() || haState == HAServiceProtocol.HAServiceState.STANDBY) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + haState);
        }
        return ret;
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws YarnException, StandbyException {
        String argName = "refreshQueues";
        String msg = "refresh queues.";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "refresh queues.");
        RefreshQueuesResponse response = (RefreshQueuesResponse)this.recordFactory.newRecordInstance(RefreshQueuesResponse.class);
        try {
            this.rmContext.getScheduler().reinitialize(this.getConfig(), this.rmContext);
            ReservationSystem rSystem = this.rmContext.getReservationSystem();
            if (rSystem != null) {
                rSystem.reinitialize(this.getConfig(), this.rmContext);
            }
            RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), argName, "refresh queues.");
        }
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws YarnException, StandbyException {
        String argName = "refreshNodes";
        String msg = "refresh nodes.";
        UserGroupInformation user = this.checkAcls("refreshNodes");
        this.checkRMStatus(user.getShortUserName(), argName, "refresh nodes.");
        try {
            Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
            this.rmContext.getNodesListManager().refreshNodes(conf);
            RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
            return (RefreshNodesResponse)this.recordFactory.newRecordInstance(RefreshNodesResponse.class);
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), argName, "refresh nodes.");
        }
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws YarnException, IOException {
        String argName = "refreshSuperUserGroupsConfiguration";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "refresh super-user-groups.");
        Configuration conf = this.getConfiguration(new Configuration(false), "core-site.xml", "yarn-site.xml");
        RMServerUtils.processRMProxyUsersConf(conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
        return (RefreshSuperUserGroupsConfigurationResponse)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationResponse.class);
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws YarnException, IOException {
        String argName = "refreshUserToGroupsMappings";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "refresh user-groups.");
        Groups.getUserToGroupsMappingService((Configuration)this.getConfiguration(new Configuration(false), "core-site.xml")).refresh();
        RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
        return (RefreshUserToGroupsMappingsResponse)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsResponse.class);
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        return this.refreshAdminAcls(true);
    }

    private RefreshAdminAclsResponse refreshAdminAcls(boolean checkRMHAState) throws YarnException, IOException {
        String argName = "refreshAdminAcls";
        UserGroupInformation user = this.checkAcls(argName);
        if (checkRMHAState) {
            this.checkRMStatus(user.getShortUserName(), argName, "refresh Admin ACLs.");
        }
        Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
        this.authorizer.setAdmins(this.getAdminAclList(conf), UserGroupInformation.getCurrentUser());
        RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
        return (RefreshAdminAclsResponse)this.recordFactory.newRecordInstance(RefreshAdminAclsResponse.class);
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        if (!this.getConfig().getBoolean("hadoop.security.authorization", false)) {
            throw RPCUtil.getRemoteException((Throwable)new IOException("Service Authorization (hadoop.security.authorization) not enabled."));
        }
        String argName = "refreshServiceAcls";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "refresh Service ACLs.");
        RMPolicyProvider policyProvider = RMPolicyProvider.getInstance();
        Configuration conf = this.getConfiguration(new Configuration(false), "hadoop-policy.xml");
        this.refreshServiceAcls(conf, policyProvider);
        this.rmContext.getClientRMService().refreshServiceAcls(conf, policyProvider);
        this.rmContext.getApplicationMasterService().refreshServiceAcls(conf, policyProvider);
        this.rmContext.getResourceTrackerService().refreshServiceAcls(conf, policyProvider);
        RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
        return (RefreshServiceAclsResponse)this.recordFactory.newRecordInstance(RefreshServiceAclsResponse.class);
    }

    private synchronized void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    public String[] getGroupsForUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        String argName = "updateNodeResource";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "update node resource.");
        Map nodeResourceMap = request.getNodeResourceMap();
        Set nodeIds = nodeResourceMap.keySet();
        for (NodeId nodeId : nodeIds) {
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) continue;
            LOG.error((Object)("Resource update get failed on all nodes due to change resource on an unrecognized node: " + nodeId));
            throw RPCUtil.getRemoteException((String)("Resource update get failed on all nodes due to change resource on an unrecognized node: " + nodeId));
        }
        boolean allSuccess = true;
        for (Map.Entry entry : nodeResourceMap.entrySet()) {
            ResourceOption newResourceOption = (ResourceOption)entry.getValue();
            NodeId nodeId = (NodeId)entry.getKey();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node == null) {
                LOG.warn((Object)("Resource update get failed on an unrecognized node: " + nodeId));
                allSuccess = false;
                continue;
            }
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeResourceUpdateEvent(nodeId, newResourceOption));
            LOG.info((Object)("Update resource on node(" + node.getNodeID() + ") with resource(" + newResourceOption.toString() + ")"));
        }
        if (allSuccess) {
            RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
        }
        UpdateNodeResourceResponse response = UpdateNodeResourceResponse.newInstance();
        return response;
    }

    private synchronized Configuration getConfiguration(Configuration conf, String ... confFileNames) throws YarnException, IOException {
        for (String confFileName : confFileNames) {
            InputStream confFileInputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, confFileName);
            if (confFileInputStream == null) continue;
            conf.addResource(confFileInputStream);
        }
        return conf;
    }

    private void refreshAll() throws ServiceFailedException {
        try {
            this.refreshQueues(RefreshQueuesRequest.newInstance());
            this.refreshNodes(RefreshNodesRequest.newInstance());
            this.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
            this.refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest.newInstance());
            if (this.getConfig().getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls(RefreshServiceAclsRequest.newInstance());
            }
        }
        catch (Exception ex) {
            throw new ServiceFailedException(ex.getMessage());
        }
    }

    @VisibleForTesting
    public AccessControlList getAccessControlList() {
        return ((ConfiguredYarnAuthorizer)this.authorizer).getAdminAcls();
    }

    @VisibleForTesting
    public RPC.Server getServer() {
        return this.server;
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        String argName = "addToClusterNodeLabels";
        String msg = "add labels.";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "add labels.");
        AddToClusterNodeLabelsResponse response = (AddToClusterNodeLabelsResponse)this.recordFactory.newRecordInstance(AddToClusterNodeLabelsResponse.class);
        try {
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels(request.getNodeLabels());
            RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), argName, "add labels.");
        }
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        String argName = "removeFromClusterNodeLabels";
        String msg = "remove labels.";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "remove labels.");
        RemoveFromClusterNodeLabelsResponse response = (RemoveFromClusterNodeLabelsResponse)this.recordFactory.newRecordInstance(RemoveFromClusterNodeLabelsResponse.class);
        try {
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(request.getNodeLabels());
            RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), argName, "remove labels.");
        }
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        String argName = "replaceLabelsOnNode";
        String msg = "set node to labels.";
        UserGroupInformation user = this.checkAcls(argName);
        this.checkRMStatus(user.getShortUserName(), argName, "set node to labels.");
        ReplaceLabelsOnNodeResponse response = (ReplaceLabelsOnNodeResponse)this.recordFactory.newRecordInstance(ReplaceLabelsOnNodeResponse.class);
        try {
            this.rmContext.getNodeLabelManager().replaceLabelsOnNode(request.getNodeToLabels());
            RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), argName, "set node to labels.");
        }
    }

    private void checkRMStatus(String user, String argName, String msg) throws StandbyException {
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user, argName, "", "AdminService", "ResourceManager is not active. Can not " + msg);
            this.throwStandbyException();
        }
    }

    private YarnException logAndWrapException(IOException ioe, String user, String argName, String msg) throws YarnException {
        LOG.info((Object)("Exception " + msg), (Throwable)ioe);
        RMAuditLogger.logFailure(user, argName, "", "AdminService", "Exception " + msg);
        return RPCUtil.getRemoteException((Throwable)ioe);
    }
}

