/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestHostFileManager {
    private static InetSocketAddress entry(String e) {
        return HostFileManager.parseEntry((String)"dummy", (String)"dummy", (String)e);
    }

    @Test
    public void testDeduplication() {
        HostFileManager.HostSet s = new HostFileManager.HostSet();
        s.add(TestHostFileManager.entry("127.0.0.1:12345"));
        s.add(TestHostFileManager.entry("localhost:12345"));
        Assert.assertEquals((long)1L, (long)s.size());
        s.add(TestHostFileManager.entry("127.0.0.1:12345"));
        Assert.assertEquals((long)1L, (long)s.size());
        s.add(TestHostFileManager.entry("127.0.0.1:12346"));
        Assert.assertEquals((long)2L, (long)s.size());
        s.add(TestHostFileManager.entry("127.0.0.1"));
        Assert.assertEquals((long)3L, (long)s.size());
        s.add(TestHostFileManager.entry("127.0.0.10"));
        Assert.assertEquals((long)4L, (long)s.size());
    }

    @Test
    public void testRelation() {
        HostFileManager.HostSet s = new HostFileManager.HostSet();
        s.add(TestHostFileManager.entry("127.0.0.1:123"));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:123")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.1:12")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.1")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:12")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:123")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2:123")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2:123")));
        s.add(TestHostFileManager.entry("127.0.0.1"));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:123")));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:12")));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:12")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:123")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2:123")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2:123")));
        s.add(TestHostFileManager.entry("127.0.0.2:123"));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:123")));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:12")));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1")));
        Assert.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:12")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:123")));
        Assert.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2")));
        Assert.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.2:123")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2")));
        Assert.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2:123")));
    }

    @Test
    public void testIncludeExcludeLists() throws IOException {
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Configuration conf = new Configuration();
        HostFileManager hm = (HostFileManager)Mockito.mock(HostFileManager.class);
        HostFileManager.HostSet includedNodes = new HostFileManager.HostSet();
        HostFileManager.HostSet excludedNodes = new HostFileManager.HostSet();
        includedNodes.add(TestHostFileManager.entry("127.0.0.1:12345"));
        includedNodes.add(TestHostFileManager.entry("localhost:12345"));
        includedNodes.add(TestHostFileManager.entry("127.0.0.1:12345"));
        includedNodes.add(TestHostFileManager.entry("127.0.0.2"));
        excludedNodes.add(TestHostFileManager.entry("127.0.0.1:12346"));
        excludedNodes.add(TestHostFileManager.entry("127.0.30.1:12346"));
        Assert.assertEquals((long)2L, (long)includedNodes.size());
        Assert.assertEquals((long)2L, (long)excludedNodes.size());
        ((HostFileManager)Mockito.doReturn((Object)includedNodes).when((Object)hm)).getIncludes();
        ((HostFileManager)Mockito.doReturn((Object)excludedNodes).when((Object)hm)).getExcludes();
        DatanodeManager dm = new DatanodeManager(bm, (Namesystem)fsn, conf);
        Whitebox.setInternalState((Object)dm, (String)"hostFileManager", (Object)hm);
        Map dnMap = (Map)Whitebox.getInternalState((Object)dm, (String)"datanodeMap");
        Assert.assertEquals((long)2L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL).size());
        Assert.assertEquals((long)2L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        dnMap.put("uuid-foo", new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "uuid-foo", 12345, 1020, 1021, 1022)));
        Assert.assertEquals((long)1L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        dnMap.put("uuid-bar", new DatanodeDescriptor(new DatanodeID("127.0.0.2", "127.0.0.2", "uuid-bar", 12345, 1020, 1021, 1022)));
        Assert.assertEquals((long)0L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        DatanodeDescriptor spam = new DatanodeDescriptor(new DatanodeID("127.0.0.3", "127.0.0.3", "uuid-spam", 12345, 1020, 1021, 1022));
        DFSTestUtil.setDatanodeDead((DatanodeInfo)spam);
        includedNodes.add(TestHostFileManager.entry("127.0.0.3:12345"));
        dnMap.put("uuid-spam", spam);
        Assert.assertEquals((long)1L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        dnMap.remove("uuid-spam");
        Assert.assertEquals((long)1L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        excludedNodes.add(TestHostFileManager.entry("127.0.0.3"));
        Assert.assertEquals((long)0L, (long)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
    }
}

