/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestListCorruptFileBlocks {
    static final Logger LOG = NameNode.stateChangeLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testListCorruptFilesCorruptedBlock() throws Exception {
        MiniDFSCluster cluster = null;
        Random random = new Random();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            conf.setInt("dfs.client.retry.window.base", 10);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testCorruptFilesCorruptedBlock").setNumFiles(2).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat10");
            NameNode namenode = cluster.getNameNode();
            Collection badFiles = namenode.getNamesystem().listCorruptFileBlocks("/", null);
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " corrupt files. Expecting None."), (badFiles.size() == 0 ? 1 : 0) != 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getInstanceStorageDir(0, 1);
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            List<File> metaFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
            Assert.assertTrue((String)"Data directory does not contain any blocks or there was an IO error", (metaFiles != null && !metaFiles.isEmpty() ? 1 : 0) != 0);
            File metaFile = metaFiles.get(0);
            RandomAccessFile file = new RandomAccessFile(metaFile, "rw");
            FileChannel channel = file.getChannel();
            long position = channel.size() - 2L;
            int length = 2;
            byte[] buffer = new byte[length];
            random.nextBytes(buffer);
            channel.write(ByteBuffer.wrap(buffer), position);
            file.close();
            LOG.info("Deliberately corrupting file " + metaFile.getName() + " at offset " + position + " length " + length);
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assert.assertTrue((String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e), (boolean)false);
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."), (badFiles.size() == 1 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/srcdat10");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=300000L)
    public void testListCorruptFileBlocksInSafeMode() throws Exception {
        MiniDFSCluster cluster = null;
        Random random = new Random();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            conf.setFloat("dfs.namenode.safemode.threshold-pct", 1.5f);
            conf.setFloat("dfs.namenode.replqueue.threshold-pct", 0.0f);
            conf.setInt("dfs.client.retry.window.base", 10);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).waitSafeMode(false).build();
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testListCorruptFileBlocksInSafeMode").setNumFiles(2).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat10");
            Collection badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " corrupt files. Expecting None."), (badFiles.size() == 0 ? 1 : 0) != 0);
            File storageDir = cluster.getInstanceStorageDir(0, 0);
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, cluster.getNamesystem().getBlockPoolId());
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            List<File> metaFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
            Assert.assertTrue((String)"Data directory does not contain any blocks or there was an IO error", (metaFiles != null && !metaFiles.isEmpty() ? 1 : 0) != 0);
            File metaFile = metaFiles.get(0);
            RandomAccessFile file = new RandomAccessFile(metaFile, "rw");
            FileChannel channel = file.getChannel();
            long position = channel.size() - 2L;
            int length = 2;
            byte[] buffer = new byte[length];
            random.nextBytes(buffer);
            channel.write(ByteBuffer.wrap(buffer), position);
            file.close();
            LOG.info("Deliberately corrupting file " + metaFile.getName() + " at offset " + position + " length " + length);
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assert.assertTrue((String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e), (boolean)false);
            }
            badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."), (badFiles.size() == 1 ? 1 : 0) != 0);
            cluster.restartNameNode(0);
            fs = cluster.getFileSystem();
            while (!cluster.getNameNode().namesystem.isPopulatingReplQueues()) {
                try {
                    LOG.info("waiting for replication queues");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assert.assertTrue((String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e), (boolean)false);
            }
            badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."), (badFiles.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Namenode is not in safe mode", (boolean)cluster.getNameNode().isInSafeMode());
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            util.cleanup((FileSystem)fs, "/srcdat10");
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testlistCorruptFileBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData");
            NameNode namenode = cluster.getNameNode();
            Collection corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
            int numCorrupt = corruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                    List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                    if (metadataFiles == null) continue;
                    for (File metadataFile : metadataFiles) {
                        File blockFile = Block.metaToBlockFile((File)metadataFile);
                        LOG.info("Deliberately removing file " + blockFile.getName());
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)blockFile.delete());
                        LOG.info("Deliberately removing file " + metadataFile.getName());
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)metadataFile.delete());
                    }
                }
            }
            int count = 0;
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
            numCorrupt = corruptFileBlocks.size();
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
                numCorrupt = corruptFileBlocks.size();
                if (++count <= 30) continue;
            }
            LOG.info("Namenode has bad files. " + numCorrupt);
            Assert.assertTrue((numCorrupt == 3 ? 1 : 0) != 0);
            FSNamesystem.CorruptFileBlockInfo[] cfb = corruptFileBlocks.toArray(new FSNamesystem.CorruptFileBlockInfo[0]);
            String[] cookie = new String[]{"1"};
            Collection nextCorruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", cookie);
            FSNamesystem.CorruptFileBlockInfo[] ncfb = nextCorruptFileBlocks.toArray(new FSNamesystem.CorruptFileBlockInfo[0]);
            numCorrupt = nextCorruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ncfb[0].block.getBlockName().equalsIgnoreCase(cfb[1].block.getBlockName()));
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", cookie);
            numCorrupt = corruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            util.createFiles((FileSystem)fs, "/goodData");
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/goodData", null);
            numCorrupt = corruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private int countPaths(RemoteIterator<Path> iter) throws IOException {
        int i = 0;
        while (iter.hasNext()) {
            LOG.info("PATH: " + ((Path)iter.next()).toUri().getPath());
            ++i;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testlistCorruptFileBlocksDFS() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData");
            RemoteIterator corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
            int numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 2; ++i) {
                File storageDir = cluster.getInstanceStorageDir(0, i);
                File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    LOG.info("Deliberately removing file " + blockFile.getName());
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)blockFile.delete());
                    LOG.info("Deliberately removing file " + metadataFile.getName());
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)metadataFile.delete());
                }
            }
            int count = 0;
            corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
            numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
                numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
                if (++count <= 30) continue;
            }
            LOG.info("Namenode has bad files. " + numCorrupt);
            Assert.assertTrue((numCorrupt == 3 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMaxCorruptFiles() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            int maxCorruptFileBlocks = 100;
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testMaxCorruptFiles").setNumFiles(300).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat2", (short)1);
            util.waitReplication((FileSystem)fs, "/srcdat2", (short)1);
            NameNode namenode = cluster.getNameNode();
            Collection badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " corrupt files. Expecting none."), (badFiles.size() == 0 ? 1 : 0) != 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                    LOG.info("Removing files from " + data_dir);
                    List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                    if (metadataFiles == null) continue;
                    for (File metadataFile : metadataFiles) {
                        File blockFile = Block.metaToBlockFile((File)metadataFile);
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)blockFile.delete());
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)metadataFile.delete());
                    }
                }
            }
            LOG.info("Restarting Datanode to trigger BlockPoolSliceScanner");
            cluster.restartDataNodes();
            cluster.waitActive();
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            while (badFiles.size() < 100) {
                LOG.info("# of corrupt files is: " + badFiles.size());
                Thread.sleep(10000L);
                badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting " + 100 + "."), (badFiles.size() == 100 ? 1 : 0) != 0);
            CorruptFileBlockIterator iter = (CorruptFileBlockIterator)fs.listCorruptFileBlocks(new Path("/srcdat2"));
            int corruptPaths = this.countPaths((RemoteIterator<Path>)iter);
            Assert.assertTrue((String)("Expected more than 100 corrupt file blocks but got " + corruptPaths), (corruptPaths > 100 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Iterator should have made more than 1 call but made " + iter.getCallsMade()), (iter.getCallsMade() > 1 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/srcdat2");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

