/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestProcessCorruptBlocks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhenDecreasingReplication() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            Assert.assertEquals((long)2L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)1L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            namesystem.setReplication(fileName.toString(), (short)2);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            Assert.assertEquals((long)2L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)0L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testByAddingAnExtraDataNode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        MiniDFSCluster.DataNodeProperties dnPropsFourth = cluster.stopDataNode(3);
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            Assert.assertEquals((long)2L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)1L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            cluster.restartDataNode(dnPropsFourth);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            Assert.assertEquals((long)3L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)0L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testWithReplicationFactorAsOne() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)2, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)1);
            Assert.assertEquals((long)1L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)1L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            namesystem.setReplication(fileName.toString(), (short)1);
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                if (TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas() == 0) break;
            }
            Assert.assertEquals((long)1L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)0L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithAllCorruptReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 1, block);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 2, block);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)3L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            namesystem.setReplication(fileName.toString(), (short)1);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assert.assertEquals((long)3L, (long)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    private static NumberReplicas countReplicas(FSNamesystem namesystem, ExtendedBlock block) {
        return namesystem.getBlockManager().countNodes(block.getLocalBlock());
    }

    private void corruptBlock(MiniDFSCluster cluster, FileSystem fs, Path fileName, int dnIndex, ExtendedBlock block) throws IOException {
        Assert.assertTrue((boolean)cluster.corruptReplica(dnIndex, block));
        MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
        for (int dirIndex = 0; dirIndex < 2; ++dirIndex) {
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getStorageDir(dnIndex, dirIndex);
            File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            File scanLogFile = new File(dataDir, "dncp_block_verification.log.curr");
            if (!scanLogFile.exists()) continue;
            int i = 0;
            while (!scanLogFile.delete()) {
                Assert.assertTrue((String)"Could not delete log file in one minute", (i < 60 ? 1 : 0) != 0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ++i;
            }
        }
        cluster.restartDataNode(dnProps);
    }
}

