/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTracing {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;

    @Test
    public void testTracing() throws Exception {
        String fileName = "testTracingDisabled.dat";
        this.writeTestFile(fileName);
        Assert.assertTrue((SetSpanReceiver.SetHolder.size() == 0 ? 1 : 0) != 0);
        this.readTestFile(fileName);
        Assert.assertTrue((SetSpanReceiver.SetHolder.size() == 0 ? 1 : 0) != 0);
        this.writeWithTracing();
        this.readWithTracing();
    }

    public void writeWithTracing() throws Exception {
        String[] spansInTopTrace;
        long startTime = System.currentTimeMillis();
        TraceScope ts = Trace.startSpan((String)"testWriteTraceHooks", (Sampler)Sampler.ALWAYS);
        this.writeTestFile("testWriteTraceHooks.dat");
        long endTime = System.currentTimeMillis();
        ts.close();
        String[] expectedSpanNames = new String[]{"testWriteTraceHooks", "org.apache.hadoop.hdfs.protocol.ClientProtocol.create", "ClientNamenodeProtocol#create", "org.apache.hadoop.hdfs.protocol.ClientProtocol.fsync", "ClientNamenodeProtocol#fsync", "org.apache.hadoop.hdfs.protocol.ClientProtocol.complete", "ClientNamenodeProtocol#complete", "newStreamForCreate", "DFSOutputStream#writeChunk", "DFSOutputStream#close", "dataStreamer", "OpWriteBlockProto", "org.apache.hadoop.hdfs.protocol.ClientProtocol.addBlock", "ClientNamenodeProtocol#addBlock"};
        TestTracing.assertSpanNamesFound(expectedSpanNames);
        Map<String, List<Span>> map = SetSpanReceiver.SetHolder.getMap();
        Span s = map.get("testWriteTraceHooks").get(0);
        Assert.assertNotNull((Object)s);
        long spanStart = s.getStartTimeMillis();
        long spanEnd = s.getStopTimeMillis();
        for (String desc : spansInTopTrace = new String[]{"testWriteTraceHooks", "org.apache.hadoop.hdfs.protocol.ClientProtocol.create", "ClientNamenodeProtocol#create", "org.apache.hadoop.hdfs.protocol.ClientProtocol.fsync", "ClientNamenodeProtocol#fsync", "org.apache.hadoop.hdfs.protocol.ClientProtocol.complete", "ClientNamenodeProtocol#complete", "newStreamForCreate", "DFSOutputStream#writeChunk", "DFSOutputStream#close"}) {
            for (Span span : map.get(desc)) {
                Assert.assertEquals((long)ts.getSpan().getTraceId(), (long)span.getTraceId());
            }
        }
        SetSpanReceiver.SetHolder.spans.clear();
    }

    public void readWithTracing() throws Exception {
        String fileName = "testReadTraceHooks.dat";
        this.writeTestFile(fileName);
        long startTime = System.currentTimeMillis();
        TraceScope ts = Trace.startSpan((String)"testReadTraceHooks", (Sampler)Sampler.ALWAYS);
        this.readTestFile(fileName);
        ts.close();
        long endTime = System.currentTimeMillis();
        String[] expectedSpanNames = new String[]{"testReadTraceHooks", "org.apache.hadoop.hdfs.protocol.ClientProtocol.getBlockLocations", "ClientNamenodeProtocol#getBlockLocations", "OpReadBlockProto"};
        TestTracing.assertSpanNamesFound(expectedSpanNames);
        Map<String, List<Span>> map = SetSpanReceiver.SetHolder.getMap();
        Span s = map.get("testReadTraceHooks").get(0);
        Assert.assertNotNull((Object)s);
        long spanStart = s.getStartTimeMillis();
        long spanEnd = s.getStopTimeMillis();
        Assert.assertTrue((spanStart - startTime < 100L ? 1 : 0) != 0);
        Assert.assertTrue((spanEnd - endTime < 100L ? 1 : 0) != 0);
        for (Span span : SetSpanReceiver.SetHolder.spans.values()) {
            Assert.assertEquals((long)ts.getSpan().getTraceId(), (long)span.getTraceId());
        }
        SetSpanReceiver.SetHolder.spans.clear();
    }

    private void writeTestFile(String testFileName) throws Exception {
        Path filePath = new Path(testFileName);
        FSDataOutputStream stream = dfs.create(filePath);
        for (int i = 0; i < 10; ++i) {
            byte[] data = RandomStringUtils.randomAlphabetic((int)102400).getBytes();
            stream.write(data);
        }
        stream.hsync();
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTestFile(String testFileName) throws Exception {
        Path filePath = new Path(testFileName);
        FSDataInputStream istream = dfs.open(filePath, 10240);
        ByteBuffer buf = ByteBuffer.allocate(10240);
        int count = 0;
        try {
            while (istream.read(buf) > 0) {
                ++count;
                buf.clear();
                istream.seek(istream.getPos() + 5L);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            istream.close();
        }
    }

    @BeforeClass
    public static void setup() throws IOException {
        conf = new Configuration();
        conf.setLong("dfs.blocksize", 102400L);
        conf.set("dfs.client.htrace.spanreceiver.classes", SetSpanReceiver.class.getName());
    }

    @Before
    public void startCluster() throws IOException {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
        SetSpanReceiver.SetHolder.spans.clear();
    }

    @After
    public void shutDown() throws IOException {
        cluster.shutdown();
    }

    static void assertSpanNamesFound(final String[] expectedSpanNames) {
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    Map<String, List<Span>> map = SetSpanReceiver.SetHolder.getMap();
                    for (String spanName : expectedSpanNames) {
                        if (map.containsKey(spanName)) continue;
                        return false;
                    }
                    return true;
                }
            }, (int)100, (int)1000);
        }
        catch (TimeoutException e) {
            Assert.fail((String)("timed out to get expected spans: " + e.getMessage()));
        }
        catch (InterruptedException e) {
            Assert.fail((String)("interrupted while waiting spans: " + e.getMessage()));
        }
    }

    public static class SetSpanReceiver
    implements SpanReceiver {
        public SetSpanReceiver(HTraceConfiguration conf) {
        }

        public void receiveSpan(Span span) {
            SetHolder.spans.put(span.getSpanId(), span);
        }

        public void close() {
        }

        public static class SetHolder {
            public static ConcurrentHashMap<Long, Span> spans = new ConcurrentHashMap();

            public static int size() {
                return spans.size();
            }

            public static Map<String, List<Span>> getMap() {
                HashMap<String, List<Span>> map = new HashMap<String, List<Span>>();
                for (Span s : spans.values()) {
                    LinkedList<Span> l = (LinkedList<Span>)map.get(s.getDescription());
                    if (l == null) {
                        l = new LinkedList<Span>();
                        map.put(s.getDescription(), l);
                    }
                    l.add(s);
                }
                return map;
            }
        }
    }
}

