/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;

public class ApplicationQueue {
    static final Logger log = Logger.getLogger("org.hypertable.AsyncComm.ApplicationQueue");
    private static boolean ms_shutdown = false;
    private LinkedList<WorkRec> mQueue = new LinkedList();
    private HashMap<Long, UsageRec> mUsageMap = new HashMap();
    private Thread[] threads = null;

    public ApplicationQueue(int workerCount) {
        assert (workerCount > 0);
        this.threads = new Thread[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            Worker worker = new Worker(this.mQueue, this.mUsageMap);
            this.threads[i] = new Thread((Runnable)worker, "ApplicationQueueThread " + i);
            this.threads[i].start();
        }
    }

    public void Join() {
        try {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void Shutdown() {
        ms_shutdown = true;
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add(ApplicationHandler appHandler) {
        long threadGroup = appHandler.GetThreadGroup();
        WorkRec rec = new WorkRec();
        rec.appHandler = appHandler;
        Cloneable cloneable = this.mUsageMap;
        synchronized (cloneable) {
            rec.usage = this.mUsageMap.get(threadGroup);
            if (rec.usage != null) {
                ++rec.usage.outstanding;
            } else {
                rec.usage = new UsageRec();
                rec.usage.threadGroup = threadGroup;
                this.mUsageMap.put(threadGroup, rec.usage);
            }
        }
        cloneable = this.mQueue;
        synchronized (cloneable) {
            this.mQueue.addLast(rec);
            this.mQueue.notify();
        }
    }

    private static class Worker
    implements Runnable {
        LinkedList<WorkRec> mQueue;
        HashMap<Long, UsageRec> mUsageMap;

        Worker(LinkedList<WorkRec> workQueue, HashMap<Long, UsageRec> usageMap) {
            this.mQueue = workQueue;
            this.mUsageMap = usageMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkRec rec = null;
            block23: while (true) {
                try {
                    while (!Thread.interrupted()) {
                        Cloneable cloneable = this.mQueue;
                        synchronized (cloneable) {
                            while (this.mQueue.isEmpty()) {
                                if (ms_shutdown) {
                                    return;
                                }
                                this.mQueue.wait();
                            }
                            ListIterator<WorkRec> iter = this.mQueue.listIterator(0);
                            HashMap<Long, UsageRec> hashMap = this.mUsageMap;
                            synchronized (hashMap) {
                                while (iter.hasNext()) {
                                    rec = iter.next();
                                    if (rec.usage == null || !rec.usage.running) {
                                        if (rec.usage != null) {
                                            rec.usage.running = true;
                                        }
                                        iter.remove();
                                        break;
                                    }
                                    rec = null;
                                }
                            }
                            if (rec == null) {
                                if (ms_shutdown) {
                                    return;
                                }
                                this.mQueue.wait();
                                if (ms_shutdown) {
                                    return;
                                }
                            }
                        }
                        if (rec == null) continue;
                        try {
                            rec.appHandler.run();
                            if (rec.usage == null) continue;
                            cloneable = this.mUsageMap;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue block23;
                        }
                        finally {
                            if (rec.usage == null) continue;
                            HashMap<Long, UsageRec> e = this.mUsageMap;
                            synchronized (e) {
                                rec.usage.running = false;
                                --rec.usage.outstanding;
                                if (rec.usage.outstanding == 0) {
                                    this.mUsageMap.remove(rec.usage.threadGroup);
                                }
                                continue block23;
                            }
                        }
                        synchronized (cloneable) {
                            rec.usage.running = false;
                            --rec.usage.outstanding;
                            if (rec.usage.outstanding == 0) {
                                this.mUsageMap.remove(rec.usage.threadGroup);
                            }
                            continue block23;
                        }
                    }
                    break;
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    private static class WorkRec {
        ApplicationHandler appHandler = null;
        UsageRec usage = null;

        private WorkRec() {
        }
    }

    private static class UsageRec {
        long threadGroup = 0L;
        boolean running = false;
        int outstanding = 1;

        private UsageRec() {
        }
    }
}

